/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.esrawreport10.impl;



import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportType;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;

import easybox.petalslink.com.esrawreport._1.EJaxbReportTimeStampType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportType;


class ReportTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbReportType> implements
ReportType {

    protected ReportTypeImpl(XmlContext xmlContext, EJaxbReportType jaxbModel) {
        super(xmlContext, jaxbModel);
    }


    @Override
    protected Class<? extends EJaxbReportType> getCompliantModelClass() {
        return EJaxbReportType.class;
    }


    @Override
    public String getExchangeId() {
        return this.getModelObject().getExchangeId();
    }


    @Override
    public void setExchangeId(String value) {
        this.getModelObject().setExchangeId(value);
    }


    @Override
    public boolean hasExchangeId() {
        return this.getExchangeId() != null;
    }


    @Override
    public Date getDateInGMT() {
        if(this.getModelObject().getDateInGMT() != null){
            return this.getModelObject().getDateInGMT().toGregorianCalendar().getTime();
        }else return null;
    }


    @Override
    public void setDateInGMT(Date value) {
        if (value != null) {
            try {
                final GregorianCalendar gCalendar = new GregorianCalendar();
                gCalendar.setTime(value);

                final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

                this.getModelObject().setDateInGMT(xmlCalendar);
            } catch (final DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.getModelObject().setDateInGMT(null);
        }
    }


    @Override
    public boolean hasDateInGMT() {
        return this.getDateInGMT() != null;
    }


    @Override
    public String getConsumerEndpointAddress() {
        return this.getModelObject().getConsumerEndpointAddress();
    }


    @Override
    public void setConsumerEndpointAddress(String value) {
        this.getModelObject().setConsumerEndpointAddress(value);
    }


    @Override
    public boolean hasConsumerEndpointAddress() {
        return this.getConsumerEndpointAddress() != null;
    }


    @Override
    public QName getServiceQName() {
        return this.getModelObject().getServiceQName();
    }


    @Override
    public void setServiceQName(QName value) {
        this.getModelObject().setServiceQName(value);
    }


    @Override
    public boolean hasServiceQName() {
        return this.getServiceQName() != null;
    }


    @Override
    public String getOperationName() {
        return this.getModelObject().getOperationName();
    }


    @Override
    public void setOperationName(String value) {
        this.getModelObject().setOperationName(value);
    }


    @Override
    public boolean hasOperationName() {
        return this.getOperationName() != null;
    }


    @Override
    public QName getInterfaceQName() {
        return this.getModelObject().getInterfaceQName();
    }


    @Override
    public void setInterfaceQName(QName value) {
        this.getModelObject().setInterfaceQName(value);
    }


    @Override
    public boolean hasInterfaceQName() {
        return this.getInterfaceQName() != null;
    }


    @Override
    public String getProviderEndpointAddress() {
        return this.getModelObject().getProviderEndpointAddress();
    }


    @Override
    public void setProviderEndpointAddress(String value) {
        this.getModelObject().setProviderEndpointAddress(value);
    }


    @Override
    public boolean hasProviderEndpointAddress() {
        return this.getProviderEndpointAddress() != null;
    }


    @Override
    public String getEndpointName() {
        return this.getModelObject().getEndpointName();
    }


    @Override
    public void setEndpointName(String value) {
        this.getModelObject().setEndpointName(value);
    }


    @Override
    public boolean hasEndpointName() {
        return this.getEndpointName() != null;
    }


    @Override
    public long getContentLength() {
        return this.getModelObject().getContentLength();
    }


    @Override
    public void setContentLength(long value) {
        this.getModelObject().setContentLength(value);
    }


    @Override
    public boolean isDoesThisResponseIsAnException() {
        return this.getModelObject().isDoesThisResponseIsAnException();
    }


    @Override
    public void setDoesThisResponseIsAnException(boolean value) {
        this.getModelObject().setDoesThisResponseIsAnException(value);
    }





    @Override
    public Object getAny() {
        return this.getModelObject().getAny();
    }


    @Override
    public void setAny(Object value) {
        this.getModelObject().setAny(value);
    }


    @Override
    public boolean hasAny() {
        return this.getAny() != null;
    }


    @Override
    public void setTimeStamp(TimeStampType t) {
        if(t == null) this.getModelObject().setTimeStamp(null);
        if(t.equals(TimeStampType.t1)){
            this.getModelObject().setTimeStamp(EJaxbReportTimeStampType.T_1);
        }else  if(t.equals(TimeStampType.t2)){
            this.getModelObject().setTimeStamp(EJaxbReportTimeStampType.T_2);
        }else  if(t.equals(TimeStampType.t3)){
            this.getModelObject().setTimeStamp(EJaxbReportTimeStampType.T_3);
        }else if(t.equals(TimeStampType.t4)){
            this.getModelObject().setTimeStamp(EJaxbReportTimeStampType.T_4);
        }



    }

    @Override
    public TimeStampType getTimeStamp() {
        if(this.getModelObject().getTimeStamp() == null) return null;
        return TimeStampType.valueOf(this.getModelObject().getTimeStamp().value());
    }


    @Override
    public boolean hasTimeStamp() {
        return this.getModelObject().isSetTimeStamp();
    }


}
