package com.petalslink.esstar.essynchronizer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;

import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.esstar.essynchronizer.impl.service.notification.NotificationResourcesConsumer;
import com.petalslink.esstar.essynchronizer.impl.thread.ResourceIdListSynchronizerThread;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.Fault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.GetAllEnvironments;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.GetAllEnvironmentsResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.UnconnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.UnconnectToEnvironmentResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnexionManager;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.GetAllEnvironmentsFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.SynchronizeFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.UnconnectToEnvironmentFault;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformation;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbInterfaceConnectorType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformation;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;


@javax.jws.WebService(
        serviceName = "ConnexionManagerService",
        portName = "ConnexionManagerPort",
        targetNamespace = "http://www.petalslink.com/esstar/execution.environment.synchronizer.impl/1.0",
        wsdlLocation = "execution-environment-synchronizer-impl-1.0.wsdl",
        endpointInterface = "com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnexionManager")
public class ConnexionManagerImpl implements ConnexionManager {

	private static Logger LOG = Logger.getLogger(ConnexionManagerImpl.class.getName());

	private Map<String, EJaxbExecutionEnvironmentInformation> executionEnvironment = Collections.synchronizedMap(new HashMap<String, EJaxbExecutionEnvironmentInformation>());

	private Map<String, Document> connectedBussinessNodes = Collections.synchronizedMap(new HashMap<String, Document>());

	private static ConnexionManagerImpl INSTANCE = null;

	private NotificationConsumer_NotifierEndpoint_Server notifServer = null;

	private ObjectFactory notifFactory = null;

	private AbstractResourcesManager manager = null;

	private String host = null;

	private Integer notification_port = null;


	private ConnexionManagerImpl() {
		notifFactory = new ObjectFactory();
	}

	public static ConnexionManagerImpl getInstance() {
		if(INSTANCE == null) {
			INSTANCE = new ConnexionManagerImpl();
		}
		return INSTANCE;
	}

	@Override
	public void synchronize() throws SynchronizeFault {
		for(String address: this.executionEnvironment.keySet()) {
			AdminManagementClientSOAP client;
			try {
				client = new AdminManagementClientSOAP(address);
				GetResourceIdentifiers request = new GetResourceIdentifiers();
				GetResourceIdentifiersResponse response = client.getResourceIdentifiers(request);

				if(this.manager == null) {
					throw new RuntimeException("manager cannot be null!!!");
				}

				ResourceIdListSynchronizerThread synchro = new ResourceIdListSynchronizerThread(response.getResourceIdentifier(), address, client, this.manager);
				synchro.start();

			} catch (ManagementException e) {
				Fault fault = new Fault();
				fault.setMessage(e.getMessage());
				com.petalslink.esstar.execution_environment_synchronizer_impl._1.SynchronizeFault f = new com.petalslink.esstar.execution_environment_synchronizer_impl._1.SynchronizeFault();
				f.setFault(fault);
				SynchronizeFault coreFault = new SynchronizeFault(e.getMessage(), f);
				throw coreFault;
			}

		}
	}

	@Override
	public UnconnectToEnvironmentResponse unconnectToEnvironment(UnconnectToEnvironment parameters) throws UnconnectToEnvironmentFault    { 
		UnconnectToEnvironmentResponse res = new UnconnectToEnvironmentResponse();
		res.setExecutionEnvironmentInformation(this.executionEnvironment.remove(parameters.getEndpointAddress()));
		return res;
	}

	@Override
	public ConnectToEnvironmentResponse connectToEnvironment(ConnectToEnvironment parameters) throws ConnectToEnvironmentFault    { 
		ConnectToEnvironmentResponse res = new ConnectToEnvironmentResponse();
		try {
			EJaxbExecutionEnvironmentInformation env = null;

			String endpointAddress = parameters.getEndpointAddress();
			AdminManagementClientSOAP client = new AdminManagementClientSOAP(endpointAddress);
			env = client.getExecutionEnvironmentInformation(new GetExecutionEnvironmentInformation()).getExecutionEnvironmentInformation();

			if(!this.executionEnvironment.containsKey(endpointAddress)) {

				// find subscribe interface connector
				String subscriptionAddress = findSubscriptionAddress(env);
				if(subscriptionAddress != null) {

					AdminManagementClientSOAP clientSubscribe = new AdminManagementClientSOAP(subscriptionAddress);

					if(this.host == null && this.notification_port == null && this.manager == null) {
						throw new RuntimeException("host and port cannot be null!!!");
					}

					String externalAddress = "http://" + this.host + ":" + this.notification_port + "/NoticationResourcesService";

					if(this.notifServer == null) {
						this.notifServer = new NotificationConsumer_NotifierEndpoint_Server(new NotificationResourcesConsumer(endpointAddress, client, this.manager), externalAddress);
					}
					
					QName topicUsed = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "res");
					com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe payload = WSNHelper.createSubscription(externalAddress, topicUsed);

					Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);	            
					EJaxbSubscribeResponse response = clientSubscribe.subscribe(doc);
				}
				this.executionEnvironment.put(endpointAddress, env);

			}
			res.setExecutionEnvironmentInformation(env);
		} catch (Exception e) {
			e.printStackTrace();
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentFault f = new com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentFault();
			f.setFault(fault);
			ConnectToEnvironmentFault coreFault = new ConnectToEnvironmentFault(e.getMessage(), f);
			throw coreFault;
		}
		return res;
	}


	private String findSubscriptionAddress(
			EJaxbExecutionEnvironmentInformation info) {
		String res = null;
		for(EJaxbInterfaceConnectorType itf: info.getInterfaceConnector()) {
			if(itf.getInterfaceName().getNamespaceURI().equals("http://www.petalslink.com/wsn/service/WsnProducer") && 
					itf.getInterfaceName().getLocalPart().equals("NotificationProducer") &&
					"resourcesSubscriptionEndpoint".equals(itf.getId().getValue())) {
				res = itf.getEndpointAddress();
				break;
			}
		}
		return res;
	}

	public void clear() {
		this.executionEnvironment.clear();
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public Integer getNotificationPort() {
		return notification_port;
	}

	public void setNotificationjPort(Integer port) {
		this.notification_port = port;
	}

	public AbstractResourcesManager getManager() {
		return manager;
	}

	public void setManager(AbstractResourcesManager manager) {
		this.manager = manager;
	}

	public void init(String host, Integer port, AbstractResourcesManager manager) {
		this.host = host;
		this.notification_port = port;
		this.manager = manager;
	}

	public Map<String, EJaxbExecutionEnvironmentInformation> getExecutionEnvironment() {
		return executionEnvironment;
	}

	@Override
	public GetAllEnvironmentsResponse getAllEnvironments(GetAllEnvironments parameters) throws GetAllEnvironmentsFault    { 
		GetAllEnvironmentsResponse res = new GetAllEnvironmentsResponse();
		res.getExecutionEnvironmentInformation().addAll(this.executionEnvironment.values());
		return res;
	}

	public Map<String, Document> getConnectedBussinessNodes() {
		return connectedBussinessNodes;
	}

	public void shutdown(){
		if(this.notifServer != null){
			this.notifServer.shutdown();
			this.notifServer = null;
		}
	}
}
