
/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package org.ow2.petals.notifier;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;



@javax.jws.WebService(
		serviceName = "NotifierService",
		portName = "NotifierEndpoint",
		targetNamespace = "http://petals.ow2.org/notifier",
		wsdlLocation = "notifier.wsdl",
		endpointInterface = "org.ow2.petals.notifier.NotifierServerInterface")

		public class NotificationConsumerImpl implements NotifierServerInterface {

	private static final Logger LOG = Logger.getLogger(NotificationConsumerImpl.class.getName());

	private NotificationConsumerDecorator decorator;
	
	private SOAPSender sender = new SOAPSender();
	
	private String address = null;

	public NotificationConsumerImpl(String address, NotificationConsumerDecorator decorator) {
		this.address = address;
		this.decorator = decorator;
	}



	@Override
	public void notify(EJaxbNotify notify) {
		LOG.info("Executing operation notify");
		if(this.decorator != null) {
			this.decorator.notify(notify);
		} else {
			LOG.info("Decorator is null");
		}
	}



	@Override
	public String subscribeOn(String producer, QName topic) throws SubscribeOnFault {
		String res = "OK";
		try {
			Subscribe subscribe = WSNHelper.createSubscription(address, topic);
			Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
			Document response = this.sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(doc), producer, "http://docs.oasis-open.org/wsn/bw-2");
			LOG.info("subscribe on topic: " + topic + " on producer:" + producer);
			System.out.println("subscribe on topic: " + topic + " on producer:" + producer);
		} catch (Exception e) {
			throw new SubscribeOnFault(e.getMessage(), e);
		}
		return res;
	}

}
