/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.legacy.jaxb.core;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractSchemaElementImpl<E> implements SchemaElement {
    /**
	 *
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the model
     */
    protected E model;

    protected AbstractSchemaElementImpl parent;

	protected Documentation documentation;


    public AbstractSchemaElementImpl() {
    	this.model = null;
        this.parent = null;
    }

    public AbstractSchemaElementImpl(E model, AbstractSchemaElementImpl parent) {
        this.model = model;
        this.parent = parent;
    }

    /**
     * Set the documentation for this document.
     *
     * @param docEl
     *            the documentation element
     */
    public void setDocumentation(final Documentation doc) {
        this.documentation = doc;

        /*
         * if(this.model instanceof org.w3._2001.xmlschema.Documentation) {
         * ((TDocumented)this.model).setDocumentation((TDocumentation)
         * ((com.ebmwebsourcing
         * .commons.wsdl.impl.wsdl11.Documentation)this.documentation
         * ).getModel()); } else if(this.model instanceof List) {
         * ((List<DocumentedType
         * >)this.model).add((org.w3._2001.xmlschema.Documentation)
         * ((com.ebmwebsourcing
         * .commons.wsdl.impl.Documentation)this.documentation).getModel()); }
         */
    }

    /**
     * Get the documentation.
     *
     * @return the documentation element
     */
    public Documentation getDocumentation() {
        return this.documentation;
    }

    /**
     * Create the documentation element.
     *
     * @return the documentation element
     */
    public Documentation createDocumentation() {
        final Documentation doc = null;
        /*
         * if(this.getClass().getPackage().getName().equals(Constants.WSDL11_PACKAGE
         * )) { doc = new
         * org.ow2.easywsdl.schema.test.impl.wsdl11.Documentation(); } else
         * if
         * (this.getClass().getPackage().getName().equals(Constants.WSDL20_PACKAGE
         * )) { doc = new
         * org.ow2.easywsdl.schema.test.impl.wsdl20.Documentation(); }
         */
        return doc;
    }

    /**
     * Get the map containing all the attributes defined on this element. The
     * keys are the qnames of the attributes.
     *
     * @return a map containing all the attributes defined on this element
     * @throws WSDLException
     *
     */
    public Map<QName, String> getOtherAttributes() throws XmlException {
        Map<QName, String> res = new HashMap<QName, String>();


        return res;
    }

    public E getModel() {
        return this.model;
    }

    public AbstractSchemaElementImpl getParent() {
    	return this.parent;
    }

    public AbstractSchemaElementImpl getTopParent() {
    	AbstractSchemaElementImpl top = this;
    	AbstractSchemaElementImpl current = this.parent;
    	while(current != null) {
    		top = current;
    		current = current.getParent();
    	}
    	return top;
    }
    


 
    
    public void setParent(AbstractSchemaElementImpl parent) {
		this.parent = parent;
	}
    
    public boolean equals(Object o){
    	if(o instanceof AbstractSchemaElementImpl){
    		return this.model.equals(((AbstractSchemaElementImpl) o).getModel());
    	} else {
    		return false;
    	}
    }
    
    public int hashCode(){
    	return this.model.hashCode();
    }
}
