package com.ebmwebsourcing.wsstar.addressing.definition.api.absitf;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.neethi.Policy;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaElement;

public interface AbsItfEndpointReferenceType<Ref extends AbsItfReferenceParametersType> extends SchemaElement {

    /**
     * Set the document base URI of this definition. Can be used to represent
     * the origin of the Definition, and can be exploited when resolving
     * relative URIs (e.g. in &lt;import&gt;s).
     *
     * @param documentBaseURI
     *            the document base URI of this definition
     */
    public void setDocumentBaseURI(URI documentBaseURI);

    /**
     * Get the document base URI of this definition.
     *
     * @return the document base URI
     */
    public URI getDocumentBaseURI();
	
	QName getTagQName();
	
	void setTagQName(QName name);
	
	String getAddress();
	
	void setAddress(String address);
	
	List<Policy> getPolicies();

	void setPolicy(List<Policy> policies) throws WSAddressingException;
	
	Ref getReferenceParameters() throws WSAddressingException;
	
	void setReferenceParameters(Ref ref) throws WSAddressingException;
	
	Ref newReferenceParameters() throws WSAddressingException;
}
