/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.addressing.definition;

import java.util.List;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter;

/**
 * This abstract class defines a factory API that enables applications to obtain
 * a WSDMFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 *
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSAddressingFactory {

	// Protected constructor is sufficient to suppress unauthorized calls to the constructor
	protected WSAddressingFactory() {
		
	}
	
	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
	private static class WSNotificationFactoryHolder { 
		private final static WSAddressingFactory INSTANCE = new WSAddressingFactoryImpl();
	}

	public static WSAddressingFactory getInstance() {
		return WSNotificationFactoryHolder.INSTANCE;
	}
	
	
	
    /**
     * Get a new instance of a WSDMFactory. This method follows (almost) the
     * same basic sequence of steps that JAXP follows to determine the
     * fully-qualified class name of the class which implements WSDMFactory.
     * <p>
     * The steps in order are:
     * <ol>
     * <li>Check the property file
     * META-INF/services/javax.wsdl.factory.WSDLFactory.</li>
     * <li>Check the javax.wsdl.factory.WSDLFactory system property.</li>
     * <li>Check the lib/wsdl.properties file in the JRE directory. The key will
     * have the same name as the above system property.</li>
     * <li>Use the default class name provided by the implementation.</li>
     * </ol>
     * <p>
     * Once an instance of a WSDMFactory is obtained, invoke newDefinition(),
     * newWSDLReader(), or newWSDLWriter(), to create the desired instances.
     * 
     * @Deprecated use {@link #getInstance()}
     */
	@Deprecated public static WSAddressingFactory newInstance() throws WSAddressingException {
        return new WSAddressingFactoryImpl();
    }

    /**
     * Create a new instance of a QoSMetrics.
     * @throws WSDMException
     */
    
    public abstract WSAddressingReader newWSAddressingReader() throws WSAddressingException;
    
    public abstract WSAddressingWriter newWSAddressingWriter() throws WSAddressingException;
    
    public abstract EndpointReferenceType newEndpointReferenceType() throws WSAddressingException;
    
    /**
     * Create a new instance of a WSDLWriterImpl.
     */
    public abstract void setJAXBObjectFactoryList(List<Class> objectFactories);
}
