/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader.FeatureConstants;
import com.ebmwebsourcing.wsstar.jaxb.addressing.AttributedURIType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;

public class EndpointReferenceTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> implements EndpointReferenceType {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(EndpointReferenceTypeImpl.class.getName());


	/**
	 * the baseUri
	 */
	protected URI baseURI;

	private QName tagName = new QName(Constants.WSADDRESSING_NAMESPACE, Constants.ENDPOINT_ROOT_TAG);


	private ReferenceParametersType referenceParameters;

	/**
	 * Features
	 */
	protected Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	public EndpointReferenceTypeImpl(final URI baseURI,
			final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType model,
			final Map<FeatureConstants, Object> features)
	throws WSAddressingException {
		super(model, null);
		this.baseURI = baseURI;
		this.features = features;

		if(this.model.getReferenceParameters() != null) {
			this.referenceParameters = new ReferenceParametersTypeImpl(this.model.getReferenceParameters(), this);
		}/* else {
			this.model.setReferenceParameters(new com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType());
			this.referenceParameters = new ReferenceParametersTypeImpl(this.model.getReferenceParameters(), this);
		}*/
	}

	public EndpointReferenceTypeImpl(
			final com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType model,
			final AbstractSchemaElementImpl parent)
	throws WSAddressingException {
		super(model, parent);
		if(this.model.getReferenceParameters() != null) {
			this.referenceParameters = new ReferenceParametersTypeImpl(this.model.getReferenceParameters(), this);
		} /*else {
			this.model.setReferenceParameters(new com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType());
			this.referenceParameters = new ReferenceParametersTypeImpl(this.model.getReferenceParameters(), this);
		}*/
	}

	public QName getTagQName() {
		return this.tagName;
	}

	public void setTagQName(QName name) {
		this.tagName = name;
	}

	public String getAddress() {
		String res = null;
		if(this.model.getAddress() != null) {
			res = this.model.getAddress().getValue();
		}
		return res;
	}

	public void setAddress(String address) {
		if(this.model.getAddress() == null) {
			this.model.setAddress(new AttributedURIType());
		}
		this.model.getAddress().setValue(address);
	}

	private List<Element> convertPolicies2Elements(List<Policy> policies) throws WSAddressingException {
		List<Element> res = new ArrayList<Element>();
		for (Policy policy : policies) {
			res.add(convertPolicy2Element(policy));
		}
		return res;
	}

	private Element convertPolicy2Element(Policy p) throws WSAddressingException {
		Element res = null;
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			XMLOutputFactory factory = XMLOutputFactory.newInstance();
			XMLStreamWriter writer = factory.createXMLStreamWriter(out);
			p.serialize(writer);
			out.close();

			String policy = out.toString() + "</wsp:Policy>";
			InputStream input = new ByteArrayInputStream(policy.getBytes());

			Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);

			res = doc.getDocumentElement();

		} catch (XMLStreamException e) {
			throw new WSAddressingException(e);
		} catch (IOException e) {
			throw new WSAddressingException(e);
		} catch (SAXException e) {
			throw new WSAddressingException(e);
		} catch (ParserConfigurationException e) {
			throw new WSAddressingException(e);
		}
		return res;
	}

	public List<Policy> getPolicies() {
		List<Policy> policies = new ArrayList<Policy>();
		if(this.model.getAny() != null) {
			for (Object elmt : this.model.getAny()) {
				if(elmt instanceof Element) {
					try {
						Policy p = PolicyEngine.getPolicy(XmlUtils.toOM((Element) elmt));
						policies.add(p);
					} catch (Exception e) {
						// do nothing
					}
				}
			}
		}
		return policies;
	}


	public void setPolicy(List<Policy> policies) throws WSAddressingException {
		if(policies != null) {
			for (Element e : convertPolicies2Elements(policies)) {
				this.model.getAny().add(e);
			}
		}
	}

	/**
	 * @return the features
	 */
	public Map<FeatureConstants, Object> getFeatures() {
		if (this.features == null) {
			this.features = new HashMap<FeatureConstants, Object>();
		}
		return this.features;
	}

	/**
	 * @param features
	 *            the features to set
	 */
	public void setFeatures(final Map<FeatureConstants, Object> features) {
		this.features = features;
	}

	/**
	 * methods for baseURI
	 */
	public URI getDocumentBaseURI() {
		URI res = null;
		try {
			if ((this.baseURI != null)&&(this.baseURI.getPath() != null)&&(this.baseURI.getPath().lastIndexOf("/") != -1)) {
				res = new URI(this.baseURI.getPath().substring(0,
						this.baseURI.getPath().lastIndexOf("/") + 1));
			} else {
				res = this.baseURI;
			}
		} catch (final URISyntaxException e) {
			log.warning("BaseURI is null : " + this.baseURI);
		}
		return res;
	}

	public void setDocumentBaseURI(final URI documentBaseURI) {
		this.baseURI = documentBaseURI;
	}

	public ReferenceParametersType getReferenceParameters() throws WSAddressingException {
		return this.referenceParameters;
	}

	public void setReferenceParameters(ReferenceParametersType ref) throws WSAddressingException {
		/*if (this.model.getReferenceParameters() == null) {
			this.model.setReferenceParameters(new com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType());
			this.referenceParameters = new ReferenceParametersTypeImpl(this.model.getReferenceParameters(), this);
		}*/

		if (ref != null )
			this.model.setReferenceParameters((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType) ((AbstractSchemaElementImpl)ref).getModel());
		else
			this.model.setReferenceParameters(null);
		this.referenceParameters = ref;
	}

	public ReferenceParametersType newReferenceParameters()
	throws WSAddressingException {
		return new ReferenceParametersTypeImpl(new com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType(), this);
	}


}
