/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.WSAddressingReaderImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.WSAddressingWriterImpl;

/**
 * This class is a concrete implementation of the abstract class WSDMFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressingFactoryImpl extends WSAddressingFactory {


    List<Class> objectFactories = null;

    /**
     * Create a new instance of a WSDLReaderImpl.
     * @throws WSDMException 
     */
    @Override
    public WSAddressingReader newWSAddressingReader() throws WSAddressingException {
        final WSAddressingReader reader = new WSAddressingReaderImpl(this.objectFactories);
        return reader;
    }

    /**
     * Create a new instance of a WSDLWriterImpl.
     * @throws WSDMException 
     */
    @Override
    public WSAddressingWriter newWSAddressingWriter() throws WSAddressingException {
        final WSAddressingWriter writer = new WSAddressingWriterImpl(this.objectFactories);
        return writer;
    }
    
    @Override
    public EndpointReferenceType newEndpointReferenceType() throws WSAddressingException {
        return new EndpointReferenceTypeImpl(new com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType(), null);
    }

    @Override
    public void setJAXBObjectFactoryList(List<Class> objectFactories) {
        if(this.objectFactories == null) {
            this.objectFactories = new ArrayList<Class>();
        }
        this.objectFactories.addAll(objectFactories);
    }

}
