/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.decorator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("unchecked")
public abstract class AbstractAddressingConverter<
EprNew extends AbsItfEndpointReferenceType, EprImpl extends DecoratorEndpointReferenceTypeImpl,
RefNew extends AbsItfReferenceParametersType, RefImpl extends DecoratorReferenceParametersTypeImpl> {


	public AbstractAddressingConverter() {
	}


	public abstract EprNew convertEndpointReferenceType(AbsItfEndpointReferenceType desc) throws WSAddressingException;


	protected EprNew convertEndpointReferenceType(final AbsItfEndpointReferenceType odlDesc, final Class<EprImpl> eprimpl,
			final Class<RefImpl> refimpl)
	throws WSAddressingException {
		EprNew newEpr = null;
		try {
			// create new description
			newEpr = this.convertEndpointReferenceType(odlDesc, eprimpl);

			// add reference parameters type
			if (odlDesc.getReferenceParameters() != null){
				RefNew newRef = this.convertReferenceParametersType(odlDesc.getReferenceParameters(), refimpl);
				newEpr.setReferenceParameters(newRef);
			}


		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final SchemaException e) {
			throw new WSAddressingException(e);
		}
		return newEpr;
	}


	private EprNew convertEndpointReferenceType(final AbsItfEndpointReferenceType odlDesc, final Class<EprImpl> eprimpl)
	throws WSAddressingException {
		EprNew newDesc = null;
		try {
			// create new description
			final Constructor c = eprimpl.getConstructors()[0];
			newDesc = (EprNew) c.newInstance(odlDesc);
		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final InstantiationException e) {
			throw new WSAddressingException(e);
		} catch (final IllegalAccessException e) {
			throw new WSAddressingException(e);
		} catch (final InvocationTargetException e) {
			throw new WSAddressingException(e);
		}
		return newDesc;
	}

	/**
	 * Convert all wsdl element
	 */
	private RefNew convertReferenceParametersType(final AbsItfReferenceParametersType oldRef, final Class<RefImpl> refimpl)
	throws WSAddressingException {
		RefNew newRef = null;
		try {
			final Constructor c = refimpl.getConstructors()[0];
			newRef = (RefNew) c.newInstance((AbsItfReferenceParametersType)oldRef);
		} catch (final IllegalArgumentException e) {
			throw new WSAddressingException(e);
		} catch (final InstantiationException e) {
			throw new WSAddressingException(e);
		} catch (final IllegalAccessException e) {
			throw new WSAddressingException(e);
		} catch (final InvocationTargetException e) {
			throw new WSAddressingException(e);
		}
		return newRef;
	}


}
