/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.decorator;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.neethi.Policy;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaElement;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("unchecked")
public class DecoratorEndpointReferenceTypeImpl<Ref extends AbsItfReferenceParametersType> extends AbstractSchemaElementImpl implements Decorator {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	protected AbsItfEndpointReferenceType<Ref> epr;


	public DecoratorEndpointReferenceTypeImpl(AbsItfEndpointReferenceType<Ref> epr)
	throws WSAddressingException {
		super();
		this.epr = epr;
		this.model = ((AbstractSchemaElementImpl)this.getFirstEpr()).getModel();
		
	}

	public EndpointReferenceType getFirstEpr() {
		EndpointReferenceType res = null;
		AbsItfEndpointReferenceType tmp = this.epr;
		while ((tmp != null) && (tmp instanceof DecoratorEndpointReferenceTypeImpl)) {
			tmp = ((DecoratorEndpointReferenceTypeImpl) tmp).getFirstEpr();
		}
		if (tmp instanceof EndpointReferenceType) {
			res = (EndpointReferenceType) tmp;
		}
		return res;
	}


	@Override
	public Object getModel() {
		return ((AbstractSchemaElementImpl)this.getFirstEpr()).getModel();
	}

	@Override
	public AbstractSchemaElementImpl getParent() {
		return ((AbstractSchemaElementImpl)this.epr).getParent();
	}

	public SchemaElement getDecorator() {
		return this.epr;
	}

	public String getAddress() {
		return this.epr.getAddress();
	}

	public URI getDocumentBaseURI() {
		return this.epr.getDocumentBaseURI();
	}

	public List<Policy> getPolicies() {
		return this.epr.getPolicies();
	}

	public Ref getReferenceParameters()
	throws WSAddressingException {
		return this.epr.getReferenceParameters();
	}

	public Ref newReferenceParameters()
	throws WSAddressingException {
		return this.epr.newReferenceParameters();
	}

	public QName getTagQName() {
		return this.epr.getTagQName();
	}

	public void setAddress(String address) {
		this.epr.setAddress(address);
	}

	public void setDocumentBaseURI(URI documentBaseURI) {
		this.epr.setDocumentBaseURI(documentBaseURI);
	}

	public void setPolicy(List<Policy> policies) throws WSAddressingException {
		this.epr.setPolicy(policies);
	}

	public void setReferenceParameters(Ref ref) throws WSAddressingException {
		this.epr.setReferenceParameters(ref);
	}

	public void setTagQName(QName name) {
		this.epr.setTagQName(name);
	}


}
