package com.ebmwebsourcing.wscap12.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.wscap12.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    
    @Override
    public String getName() {
        return "wscap12-impl";
    }
    
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/wscap12";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "wscap12.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.oasis.names.tc.emergency.cap._1.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.WSCAP_NS_URI;
    }
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.WSCAP_NS_PREFERRED_PREFIX;
    }
    
        
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        factorableClasses.add(AlertImpl.class);
        factorableClasses.add(EventCodeImpl.class);
        factorableClasses.add(InfoImpl.class);
        factorableClasses.add(ParameterImpl.class);
        factorableClasses.add(ResourceImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObject);
    }

}
