package com.ebmwebsourcing.wsdm10.impl;



import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.wsdm10.api.element.LastRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.MaxRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfFailedRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfSuccessfulRequests;
import com.ebmwebsourcing.wsdm10.api.element.ServiceTime;
import com.ebmwebsourcing.wsdm10.api.type.OperationMetricType;

import easybox.org.oasis_open.docs.wsdm.mows_2.EJaxbOperationMetricType;


class OperationMetricTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbOperationMetricType> implements OperationMetricType {

	OperationMetricTypeImpl(XmlContext xmlContext, EJaxbOperationMetricType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbOperationMetricType> getCompliantModelClass() {
		return EJaxbOperationMetricType.class;
	}


	@Override
	public NumberOfRequests getNumberOfRequests() {
		if(this.getModelObject().getNumberOfRequests() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getNumberOfRequests(), NumberOfRequests.class);
		} 
		return null;
	}

	@Override
	public void setNumberOfRequests(NumberOfRequests value) {
		setChild(value, NumberOfRequests.class);
	}


	@Override
	public boolean hasNumberOfRequests() {
		return this.getNumberOfRequests() != null;
	}


	@Override
	public NumberOfSuccessfulRequests getNumberOfSuccessfulRequests() {
		if(this.getModelObject().getNumberOfSuccessfulRequests() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getNumberOfSuccessfulRequests(), NumberOfSuccessfulRequests.class);
		} 
		return null;
	}


	@Override
	public void setNumberOfSuccessfulRequests(NumberOfSuccessfulRequests value) {
		setChild(value, NumberOfSuccessfulRequests.class);
	}


	@Override
	public boolean hasNumberOfSuccessfulRequests() {
		return this.getNumberOfSuccessfulRequests() != null;
	}


	@Override
	public NumberOfFailedRequests getNumberOfFailedRequests() {
		if(this.getModelObject().getNumberOfFailedRequests() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getNumberOfFailedRequests(), NumberOfFailedRequests.class);
		} 
		return null;
	}


	@Override
	public void setNumberOfFailedRequests(NumberOfFailedRequests value) {
		setChild(value, NumberOfFailedRequests.class);
	}


	@Override
	public boolean hasNumberOfFailedRequests() {
		return this.getNumberOfFailedRequests() != null;
	}


	@Override
	public ServiceTime getServiceTime() {
		if(this.getModelObject().getServiceTime() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getServiceTime(), ServiceTime.class);
		} 
		return null;
	}


	@Override
	public void setServiceTime(ServiceTime value) {
		setChild(value, ServiceTime.class);
	}


	@Override
	public boolean hasServiceTime() {
		return this.getServiceTime() != null;
	}


	@Override
	public MaxResponseTime getMaxResponseTime() {
		if(this.getModelObject().getMaxResponseTime() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getMaxResponseTime(), MaxResponseTime.class);
		} 
		return null;
	}


	@Override
	public void setMaxResponseTime(MaxResponseTime value) {
		setChild(value, MaxResponseTime.class);
	}


	@Override
	public boolean hasMaxResponseTime() {
		return this.getMaxResponseTime() != null;
	}


	@Override
	public LastResponseTime getLastResponseTime() {
		if(this.getModelObject().getLastResponseTime() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getLastResponseTime(), LastResponseTime.class);
		} 
		return null;
	}


	@Override
	public void setLastResponseTime(LastResponseTime value) {
		setChild(value, LastResponseTime.class);
	}


	@Override
	public boolean hasLastResponseTime() {
		return this.getLastResponseTime() != null;
	}


	@Override
	public MaxRequestSize getMaxRequestSize() {
		if(this.getModelObject().getMaxRequestSize() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getMaxRequestSize(), MaxRequestSize.class);
		} 
		return null;
	}


	@Override
	public void setMaxRequestSize(MaxRequestSize value) {
		setChild(value, MaxRequestSize.class);
	}


	@Override
	public boolean hasMaxRequestSize() {
		return this.getMaxRequestSize() != null;
	}


	@Override
	public LastRequestSize getLastRequestSize() {
		if(this.getModelObject().getLastRequestSize() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getLastRequestSize(), LastRequestSize.class);
		} 
		return null;
	}


	@Override
	public void setLastRequestSize(LastRequestSize value) {
		setChild(value, LastRequestSize.class);
	}


	@Override
	public boolean hasLastRequestSize() {
		return this.getLastRequestSize() != null;
	}


	@Override
	public MaxResponseSize getMaxResponseSize() {
		if(this.getModelObject().getMaxResponseSize() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getMaxResponseSize(), MaxResponseSize.class);
		} 
		return null;
	}


	@Override
	public void setMaxResponseSize(MaxResponseSize value) {
		setChild(value, MaxResponseSize.class);
	}


	@Override
	public boolean hasMaxResponseSize() {
		return this.getMaxResponseSize() != null;
	}


	@Override
	public LastResponseSize getLastResponseSize() {
		if(this.getModelObject().getLastResponseSize() != null) {
			return getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getLastResponseSize(), LastResponseSize.class);
		} 
		return null;
	}


	@Override
	public void setLastResponseSize(LastResponseSize value) {
		setChild(value, LastResponseSize.class);
	}


	@Override
	public boolean hasLastResponseSize() {
		return this.getLastResponseSize() != null;
	}


	@Override
	public String getOperationName() {
		return this.getModelObject().getOperationName();
	}


	@Override
	public void setOperationName(String value) {
		this.getModelObject().setOperationName(value);
	}


	@Override
	public boolean hasOperationName() {
		return this.getOperationName() != null;
	}


	@Override
	public QName getPortType() {
		return this.getModelObject().getPortType();
	}


	@Override
	public void setPortType(QName value) {
		this.getModelObject().setPortType(value);
	}


	@Override
	public boolean hasPortType() {
		return this.getPortType() != null;
	}


	@Override
	public Map<QName, String> getOtherAttributes() {
		return this.getModelObject().getOtherAttributes();
	}

	 @Override
	    public <X extends XmlObject> X getFirstAnyXmlObject(Class<X> interfaceClass) {
	        X[] children = getAnyXmlObjects(interfaceClass);
	        if (children.length == 0)
	            return null;
	        return children[0];

	    }


	    @Override
	    public XmlObject[] getAnyXmlObjects() {
	        XmlObject[] anyXmlObjects = createChildrenArray(getModelObject()
	                .getAny(), Object.class, AbstractJaxbXmlObjectImpl.ANY_QNAME);
	        return anyXmlObjects;

	    }


	    @Override
	    public boolean hasAnyXmlObject(QName qname) {
	        XmlObject[] anyXmlObjects = getAnyXmlObjects();
	        for (XmlObject anyXmlObject : anyXmlObjects) {
	            if (qname.equals(anyXmlObject.getXmlObjectQName()))
	        return true;
	        }
	        return false;

	    }


	    @Override
	    public XmlObject[] getAnyXmlObjects(QName qname) {
	        XmlObject[] anyXmlObjects = getAnyXmlObjects();
	        List<XmlObject> result = new ArrayList<XmlObject>();
	        for (XmlObject anyXmlObject : anyXmlObjects) {
	            if (!qname.equals(anyXmlObject.getXmlObjectQName()))
	                continue;
	            result.add(anyXmlObject);
	        }
	        return (XmlObject[]) result.toArray(new XmlObject[result.size()]);

	    }


	    @Override
	    public <X extends XmlObject> X[] getAnyXmlObjects(Class<X> interfaceClass) {
	        XmlObject[] anyXmlObjects = getAnyXmlObjects();
	        List<XmlObject> result = new ArrayList<XmlObject>();
	        for (XmlObject anyXmlObject : anyXmlObjects) {
	            if (!interfaceClass.isInstance(anyXmlObject))
	                continue;
	            result.add(anyXmlObject);
	        }
	        return (X[]) result.toArray(new XmlObject[result.size()]);

	    }


	    @Override
	    public void addAnyXmlObject(XmlObject anyXmlObject) {
	        addToAny(getModelObject().getAny(), anyXmlObject);
	        
	    }


	    @Override
	    public void removeAnyXmlObject(XmlObject anyXmlObject) {
	        removeFromChildren(getModelObject().getAny(), anyXmlObject);
	        
	    }


	    @Override
	    public void clearAnyXmlObjects() {
	        clearChildren(getModelObject().getAny(), Object.class,
	                AbstractJaxbXmlObjectImpl.ANY_QNAME);

	    }



}
