/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.api.abstractElmt;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfRedefine;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;

public abstract class AbstractSchemaImpl<E, T extends AbsItfType, El extends AbsItfElement, A extends AbsItfAttribute, Incl extends AbsItfInclude, Impt extends AbsItfImport, Red extends AbsItfRedefine>
extends AbstractSchemaElementImpl<E>
implements AbsItfSchema<T, El, A, Incl, Impt, Red> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractSchemaImpl.class.getName());
    private Map<SchemaReader.FeatureConstants, Object> features = new HashMap<SchemaReader.FeatureConstants, Object>();
    private NamespaceMapperImpl namespaceMapper = new NamespaceMapperImpl();
    private List<Impt> imports = new ArrayList<Impt>();
    private List<Incl> includes = new ArrayList<Incl>();
    private List<Red> redefines = new ArrayList<Red>();
    private List<T> types = new ArrayList<T>();
    private List<El> elements = new ArrayList<El>();
    private List<A> attributes = new ArrayList<A>();
    private String documentBaseURIString;
    private URI documentURI = null;

    public AbstractSchemaImpl() {
    }

    public abstract void initialize();

    public AbstractSchemaImpl(URI uRI, E e, NamespaceMapperImpl namespaceMapperImpl, SchemaLocatorImpl schemaLocatorImpl) {
        super(e, null);
        this.namespaceMapper = namespaceMapperImpl;
        this.documentURI = uRI;
    }

    public AbstractSchemaImpl(String string) {
        this.documentBaseURIString = string;
    }

    public void addImportElementsInAllList() {
        for (AbsItfImport absItfImport : this.imports) {
            if (absItfImport.getSchema() == null) continue;
            this.types.addAll(absItfImport.getSchema().getTypes());
            this.elements.addAll(absItfImport.getSchema().getElements());
            this.attributes.addAll(absItfImport.getSchema().getAttributes());
        }
    }

    public void addIncludeElementsInAllList() {
        for (AbsItfInclude absItfInclude : this.includes) {
            if (absItfInclude.getSchema() == null) continue;
            this.types.addAll(absItfInclude.getSchema().getTypes());
            this.elements.addAll(absItfInclude.getSchema().getElements());
            this.attributes.addAll(absItfInclude.getSchema().getAttributes());
        }
    }

    public void addIncludeElementsInAllList(AbsItfInclude absItfInclude) {
        if (absItfInclude.getSchema() != null) {
            this.types.addAll(absItfInclude.getSchema().getTypes());
            this.elements.addAll(absItfInclude.getSchema().getElements());
            this.attributes.addAll(absItfInclude.getSchema().getAttributes());
        }
    }

    public void addRedefineElementsInAllList() {
        for (AbsItfRedefine absItfRedefine : this.redefines) {
            if (absItfRedefine.getSchema() == null) continue;
            this.types.addAll(absItfRedefine.getSchema().getTypes());
            this.elements.addAll(absItfRedefine.getSchema().getElements());
            this.attributes.addAll(absItfRedefine.getSchema().getAttributes());
        }
    }

    @Override
    public void addImport(Impt Impt) {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        this.imports.add(Impt);
    }

    @Override
    public List<Impt> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        return this.imports;
    }

    @Override
    public List<Impt> getImports(String string) {
        ArrayList<AbsItfImport> arrayList = new ArrayList<AbsItfImport>();
        for (AbsItfImport absItfImport : this.imports) {
            if (!absItfImport.getNamespaceURI().equals(string)) continue;
            arrayList.add(absItfImport);
        }
        return arrayList;
    }

    @Override
    public void addInclude(Incl Incl) throws SchemaException {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        this.includes.add(Incl);
    }

    @Override
    public List<Incl> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        return this.includes;
    }

    @Override
    public List<Incl> getIncludes(URI uRI) {
        ArrayList<AbsItfInclude> arrayList = new ArrayList<AbsItfInclude>();
        for (AbsItfInclude absItfInclude : this.includes) {
            if (!absItfInclude.getLocationURI().equals(uRI)) continue;
            arrayList.add(absItfInclude);
        }
        return arrayList;
    }

    @Override
    public void addRedefine(Red Red) {
        if (this.redefines == null) {
            this.redefines = new ArrayList<Red>();
        }
        this.redefines.add(Red);
    }

    @Override
    public List<Red> getRedefines() {
        if (this.redefines == null) {
            this.redefines = new ArrayList<Red>();
        }
        return this.redefines;
    }

    @Override
    public List<Red> getRedefines(String string) {
        ArrayList<AbsItfRedefine> arrayList = new ArrayList<AbsItfRedefine>();
        for (AbsItfRedefine absItfRedefine : this.redefines) {
            if (!absItfRedefine.getLocationURI().equals(string)) continue;
            arrayList.add(absItfRedefine);
        }
        return arrayList;
    }

    @Override
    public List<T> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        return this.types;
    }

    @Override
    public T getType(QName qName) {
        AbsItfType absItfType = null;
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        for (AbsItfType absItfType2 : this.types) {
            if (!absItfType2.getQName().equals(qName)) continue;
            absItfType = absItfType2;
            break;
        }
        if (absItfType == null && SchemaFactory.getDefaultSchema() != null) {
            for (Type type : SchemaFactory.getDefaultSchema().getTypes()) {
                AbsItfType absItfType2 = type;
                if (!absItfType2.getQName().equals(qName)) continue;
                absItfType = absItfType2;
                break;
            }
        }
        return (T)absItfType;
    }

    @Override
    public void addType(T t) {
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        this.types.add(t);
    }

    @Override
    public List<A> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        return this.attributes;
    }

    @Override
    public A getAttribute(QName qName) {
        AbsItfAttribute absItfAttribute = null;
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        for (AbsItfAttribute absItfAttribute2 : this.attributes) {
            if (!absItfAttribute2.getName().equals(qName.getLocalPart()) || !absItfAttribute2.getNamespaceUri().equals(qName.getNamespaceURI())) continue;
            absItfAttribute = absItfAttribute2;
            break;
        }
        return (A)absItfAttribute;
    }

    @Override
    public void addAttribute(A a) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        this.attributes.add(a);
    }

    @Override
    public List<El> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        return this.elements;
    }

    @Override
    public El getElement(QName qName) {
        AbsItfElement absItfElement = null;
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        for (AbsItfElement absItfElement2 : this.elements) {
            if (!absItfElement2.getQName().equals(qName)) continue;
            absItfElement = absItfElement2;
            break;
        }
        return (El)absItfElement;
    }

    @Override
    public List<El> findElementsInAllSchema(QName qName) {
        ArrayList<El> arrayList = new ArrayList<El>();
        El El = this.getElement(qName);
        if (El != null) {
            arrayList.add(El);
        }
        AbsItfComplexType absItfComplexType = null;
        for (SchemaElement schemaElement : this.getElements()) {
            if (!(schemaElement.getType() instanceof AbsItfComplexType)) continue;
            absItfComplexType = (AbsItfComplexType)schemaElement.getType();
            this.findElmtInComplexType(qName, absItfComplexType, arrayList);
        }
        for (SchemaElement schemaElement : this.getTypes()) {
            if (!(schemaElement instanceof AbsItfComplexType)) continue;
            absItfComplexType = (AbsItfComplexType)schemaElement;
            this.findElmtInComplexType(qName, absItfComplexType, arrayList);
        }
        return arrayList;
    }

    private void findElmtInComplexType(QName qName, AbsItfComplexType absItfComplexType, List<El> list) {
        if (absItfComplexType.getSequence() != null) {
            for (AbsItfElement absItfElement : absItfComplexType.getSequence().getElements()) {
                if (!absItfElement.getQName().equals(qName)) continue;
                list.add(absItfElement);
            }
        }
        if (absItfComplexType.getAll() != null) {
            for (AbsItfElement absItfElement : absItfComplexType.getAll().getElements()) {
                if (!absItfElement.getQName().equals(qName)) continue;
                list.add(absItfElement);
            }
        }
    }

    @Override
    public void addElement(El El) {
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        this.elements.add(El);
    }

    @Override
    public NamespaceMapperImpl getAllNamespaces() {
        return this.namespaceMapper;
    }

    public Map<SchemaReader.FeatureConstants, Object> getFeatures() {
        if (this.features == null) {
            this.features = new HashMap<SchemaReader.FeatureConstants, Object>();
        }
        return this.features;
    }

    public void setFeatures(Map<SchemaReader.FeatureConstants, Object> map) {
        this.features = map;
    }

    @Override
    public URI getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(URI uRI) {
        this.documentURI = uRI;
    }

    public String toString() {
        return this.model.toString();
    }
}

