/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.seacloud.server;

import com.ebmwebsourcing.cep.server.Cep;
import com.ebmwebsourcing.easierbsm.admin.client.impl.BSMAdminClientImplSOAP;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMocked;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEsperDeployerModule;
import com.ebmwebsourcing.seacloud.CEPDeployer.CEPEtalisDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.ESBDeployerModule;
import com.ebmwebsourcing.seacloud.deployer.MonitoringDeployerModule;
import com.ebmwebsourcing.seacloud.model.CEPModule;
import com.ebmwebsourcing.seacloud.model.PubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.ESBPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModule;
import com.ebmwebsourcing.seacloud.pubsub.EventCloudPubSubModuleMocked;
import com.ebmwebsourcing.seacloud.server.DeployerResult;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;
import easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.ObjectFactory;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import fr.inria.eventcloud.deployment.cli.launchers.EventCloudsManagementServiceDeployer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.FileUtils;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@WebService(serviceName="CloudManagementService", portName="CloudManagementSOAPEndpoint", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class SeaCloudManagementImpl
implements CloudManagement {
    private static final Logger LOG = Logger.getLogger(SeaCloudManagementImpl.class.getName());
    private static final String EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME = "eventcloud.activate.loggers";
    private ESBDeployerModule esbDeployer = null;
    private MonitoringDeployerModule bsmDeployer = null;
    private CEPModule cepDeployer = null;
    private PubSubModule esbPubSub = null;
    private PubSubModule eventcloudPubSub = null;
    private SeaCloud.CEP_MODE mode = null;
    private String seaCloudAddress;
    private boolean useCepMock = false;
    private boolean useEventCloudMock = false;
    private List<ResourcesDescriptor> descriptors = new ArrayList<ResourcesDescriptor>();
    private List<URL> eventClouds = new ArrayList<URL>();
    private List<URL> cepEngines = new ArrayList<URL>();
    private List<URL> esbNodes = new ArrayList<URL>();
    private List<URL> monitoring = new ArrayList<URL>();
    private List<URL> easierGovAdresses = new ArrayList<URL>();

    public SeaCloudManagementImpl(ResourcesDescriptor descriptor, String seaCloudAddress, SeaCloud.CEP_MODE mode, boolean useCepMock, boolean useEventCloudMock) throws CloudManagementException {
        this.seaCloudAddress = seaCloudAddress;
        this.useCepMock = useCepMock;
        this.useEventCloudMock = useEventCloudMock;
        this.mode = mode;
        this.setDescriptor(descriptor);
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        EJaxbSubscribeResponse _esbreturn = null;
        LOG.info("Executing operation subscribe on SeaCloud");
        System.out.println(subscribeRequest);
        try {
            LOG.info("Executing subscription on eventcloudPubSub module");
            EJaxbSubscribeResponse _eventCloudreturn = this.eventcloudPubSub.subscribe(subscribeRequest);
            subscribeRequest.getConsumerReference().getAddress().setValue(this.seaCloudAddress);
            LOG.info("Executing subscription on esbPubSub module");
            _esbreturn = this.esbPubSub.subscribe(subscribeRequest);
            LOG.info("End of subscription on SeaCloud");
        }
        catch (RuntimeException e) {
            LOG.severe("Error to subscribe in SeaCloud");
            e.printStackTrace();
            throw e;
        }
        return _esbreturn;
    }

    public void notify(EJaxbNotify notify) {
        LOG.info("Executing operation notify");
        System.out.println(notify);
        try {
            System.out.println("eventCloud class: " + this.eventcloudPubSub.getClass());
            System.out.println("notify: \n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify)));
            this.eventcloudPubSub.notify(notify);
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws CloudManagementException {
        EJaxbDeployResponse _return;
        block7: {
            LOG.info("Executing operation deploy");
            System.out.println(parameters);
            _return = null;
            try {
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".bpel")) {
                    _return = this.esbDeployer.deploy(parameters);
                    break block7;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".cep")) {
                    System.out.println("deploy cep rule");
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new URL(parameters.getMainResource().getFileURI()).openStream());
                    AddStatementWithActions cepRule = (AddStatementWithActions)SOAJAXBContext.getInstance().marshallAnyType(doc, AddStatementWithActions.class);
                    this.cepDeployer.addStatementWithActions(cepRule);
                    _return = new EJaxbDeployResponse();
                    break block7;
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".soc")) {
                    if (this.useEventCloudMock) {
                        System.out.println("************* Use EventCloudPubSubModuleMocked");
                        _return = ((EventCloudPubSubModuleMocked)this.eventcloudPubSub).deploy(parameters);
                        break block7;
                    }
                    throw new CloudManagementException("TODO: Not implemented => the I3S event cloud should be exposed deploy method to set relation graph!!!");
                }
                if (parameters.getMainResource().getFileURI().toString().trim().endsWith(".ela")) {
                    _return = this.bsmDeployer.deploy(parameters);
                    break block7;
                }
                throw new CloudManagementException("Kind of file not supported here: " + parameters.getMainResource().getFileURI().toString());
            }
            catch (Exception e) {
                throw new CloudManagementException(e.getMessage(), (Throwable)e);
            }
        }
        return _return;
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        LOG.info("Executing operation getResourceProperty");
        System.out.println(getResourcePropertyRequest);
        EJaxbGetResourcePropertyResponse _return = new EJaxbGetResourcePropertyResponse();
        return _return;
    }

    public BindResponse bind(Bind parameters) throws CloudManagementException {
        LOG.info("Executing operation bind");
        System.out.println(parameters);
        BindResponse _return = this.esbDeployer.bind(parameters);
        return _return;
    }

    public String expose(QName serviceName, String endpointName) throws CloudManagementException {
        LOG.info("Executing operation expose");
        System.out.println(serviceName);
        System.out.println(endpointName);
        String _return = this.esbDeployer.expose(serviceName, endpointName);
        return _return;
    }

    public ProxifyResponse proxify(Proxify parameters) throws CloudManagementException {
        LOG.info("Executing operation proxify");
        System.out.println(parameters);
        ProxifyResponse _return = this.esbDeployer.proxify(parameters);
        return _return;
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        LOG.info("Executing operation unsubscribe");
        System.out.println(unsubscribeRequest);
        EJaxbUnsubscribeResponse _eventCloudreturn = this.eventcloudPubSub.unsubscribe(unsubscribeRequest);
        EJaxbUnsubscribeResponse _esbreturn = this.esbPubSub.unsubscribe(unsubscribeRequest);
        return _esbreturn;
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters) throws CloudManagementException {
        AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
        try {
            if (parameters.isEraseOlders()) {
                this.eventClouds = new ArrayList<URL>();
                this.cepEngines = new ArrayList<URL>();
                this.esbNodes = new ArrayList<URL>();
                this.monitoring = new ArrayList<URL>();
                this.easierGovAdresses = new ArrayList<URL>();
                this.descriptors = new ArrayList<ResourcesDescriptor>();
            }
            for (Resource rsc : parameters.getResourcesDescriptor().getResource()) {
                if (ResourceType.CEP_ENGINE.equals((Object)rsc.getType())) {
                    this.cepEngines.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.ESB.equals((Object)rsc.getType())) {
                    this.esbNodes.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.EVENT_CLOUD.equals((Object)rsc.getType())) {
                    this.eventClouds.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (ResourceType.MONITORING.equals((Object)rsc.getType())) {
                    this.monitoring.add(new URL(rsc.getAddress()));
                    continue;
                }
                if (!ResourceType.GOVERNANCE.equals((Object)rsc.getType())) continue;
                this.easierGovAdresses.add(new URL(rsc.getAddress()));
            }
            this.esbDeployer = new ESBDeployerModule(this.esbNodes);
            this.bsmDeployer = new MonitoringDeployerModule(this.monitoring);
            URL easierGovAdress = null;
            if (this.easierGovAdresses.size() > 0) {
                easierGovAdress = this.easierGovAdresses.get(0);
            }
            this.cepDeployer = this.mode == SeaCloud.CEP_MODE.ESPER ? new CEPEsperDeployerModule(this.cepEngines, this.seaCloudAddress, easierGovAdress) : new CEPEtalisDeployerModule(this.cepEngines, this.seaCloudAddress, easierGovAdress);
            this.esbPubSub = new ESBPubSubModule(this.esbNodes);
            if (this.useEventCloudMock) {
                System.out.println("************* Use EventCloudPubSubModuleMocked");
                this.eventcloudPubSub = new EventCloudPubSubModuleMocked(this.eventClouds);
            } else {
                System.out.println("************* Use EventCloudPubSubModule");
                this.eventcloudPubSub = new EventCloudPubSubModule(this.eventClouds);
            }
            this.descriptors.add(0, parameters.getResourcesDescriptor());
        }
        catch (MalformedURLException e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public List<ResourcesDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptor(ResourcesDescriptor descriptor) throws CloudManagementException {
        if (descriptor != null) {
            AddResourcesDescriptor request = new AddResourcesDescriptor();
            request.setResourcesDescriptor(descriptor);
            this.addResourcesDescriptor(request);
        }
    }

    public String updateStatement(String statementId, String statement) throws CloudManagementException {
        return this.cepDeployer.updateStatement(statementId, statement);
    }

    public String getStatementById(String statementId) throws CloudManagementException {
        return this.cepDeployer.getStatementById(statementId);
    }

    public String deleteStatement(String statementId) throws CloudManagementException {
        return this.cepDeployer.deleteStatement(statementId);
    }

    public String addStatement(String statementId, String statement) throws CloudManagementException {
        return this.cepDeployer.addStatement(statementId, statement);
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements parameters) throws CloudManagementException {
        return this.cepDeployer.listAllStatements(parameters);
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        return this.cepDeployer.addStatementWithActions(parameters);
    }

    public void stop() {
        if (!this.useEventCloudMock && this.eventcloudPubSub != null) {
            ((EventCloudPubSubModule)this.eventcloudPubSub).cleanup();
            EventCloudsManagementServiceDeployer.destroy();
        }
    }

    public static DeployerResult createRuntimeFrameworkFromDescriptor(String seaCloudAdminAddress, SeaCloud.CEP_MODE mode, ResourcesDescriptor descriptor) throws Exception {
        return SeaCloudManagementImpl.createRuntimeFrameworkFromDescriptor(seaCloudAdminAddress, mode, descriptor, true, false, false, false);
    }

    public static DeployerResult createRuntimeFrameworkFromDescriptor(String seaCloudAdminAddress, SeaCloud.CEP_MODE mode, ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock, boolean activeUI) throws Exception {
        DeployerResult result = SeaCloudManagementImpl.createDeployerResultFromDescriptor(descriptor, create, useCepMock, useEventCloudMock, activeUI);
        SeaCloud adminCloud = new SeaCloud(seaCloudAdminAddress, descriptor, SeaCloud.CEP_MODE.ESPER, useCepMock, useEventCloudMock);
        adminCloud.start();
        result.setSeaCloud(adminCloud);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static DeployerResult createDeployerResultFromDescriptor(ResourcesDescriptor descriptor, boolean create, boolean useCepMock, boolean useEventCloudMock, boolean activeUI) throws MalformedURLException, ESBException, TransportException, GovException, CloudManagementException, IOException, ConnectToEnvironmentFault, ManagementException {
        DeployerResult result = new DeployerResult();
        int esbCpt = 0;
        int monitCpt = 0;
        String easiergovConnexionManager = null;
        String easiergovEventManager = null;
        if (descriptor != null) {
            System.out.println("---------------------------------- deb");
            for (Resource resource : descriptor.getResource()) {
                if (ResourceType.ESB.equals((Object)resource.getType())) {
                    void var13_22;
                    URL esbAddress = new URL(resource.getAddress());
                    ++esbCpt;
                    Object var13_20 = null;
                    if (create) {
                        Node node = BusManagement.getInstance().createNode(new QName("http://www.petalslink.org", "EasyESB_" + esbCpt), esbAddress.getHost(), Integer.parseInt("900" + esbCpt), esbAddress.getPort());
                        node.start();
                    }
                    result.getEsbNodes().put(esbAddress.toString(), (Node)var13_22);
                    continue;
                }
                if (ResourceType.GOVERNANCE.equals((Object)resource.getType())) {
                    int port = new URL(resource.getAddress()).getPort();
                    String string = new URL(resource.getAddress()).getHost();
                    if (create) {
                        WSContainer easiergov = new WSContainer((Configuration)new ConfigurationImpl(string, port, port + 1));
                        easiergovConnexionManager = "http://" + string + ":" + port + "/services/connexionManager";
                        easiergovEventManager = "http://" + string + ":" + port + "/services/eventManager";
                        easiergov.start();
                    }
                    result.setEasierGovAdmin("http://" + string + ":" + port + "/services/adminManager");
                    continue;
                }
                if (ResourceType.CEP_ENGINE.equals((Object)resource.getType())) {
                    result.getCepNodes().put(resource.getAddress(), null);
                    if (create && useCepMock) {
                        System.out.println("---------------------------------- create cep");
                        Cep cep = new Cep(resource.getAddress());
                        System.out.println("---------------------------------- cep created");
                        try {
                            cep.start();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        System.out.println("---------------------------------- cep start");
                        continue;
                    }
                    if (!create) continue;
                    System.out.println("---------------------------------- create DiCEPE");
                    continue;
                }
                if (ResourceType.EVENT_CLOUD.equals((Object)resource.getType())) {
                    boolean activateLoggers = System.getProperty(EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME) != null ? Boolean.parseBoolean(System.getProperty(EVENTCLOUD_ACTIVATE_LOGGERS_PROPERTY_NAME)) : true;
                    URL uRL = new URL(resource.getAddress());
                    if (create && useEventCloudMock) {
                        EventCloudMocked eventCloud = new EventCloudMocked(resource.getAddress(), activeUI);
                        eventCloud.start();
                    } else if (create) {
                        // empty if block
                    }
                    result.getEventCloudNodes().put(uRL.toString(), null);
                    continue;
                }
                if (ResourceType.MONITORING.equals((Object)resource.getType())) {
                    void var13_28;
                    URL monitoringAddress = new URL(resource.getAddress());
                    ++monitCpt;
                    Object var13_26 = null;
                    if (create) {
                        Node node = BusManagement.getInstance().createBSMNode(new QName("http://www.petalslink.org", "EasierBSM_" + monitCpt), monitoringAddress.getHost(), Integer.parseInt("946" + monitCpt), monitoringAddress.getPort());
                        node.start();
                    }
                    result.getBsmNodes().put(monitoringAddress.toString(), (Node)var13_28);
                    continue;
                }
                throw new CloudManagementException("Resource deployment not implemented for: " + resource.getType());
            }
            System.out.println("---------------------------------- fin");
            if (create) {
                if (easiergovConnexionManager != null) {
                    ConnexionManagerClientImplSOAP easiergovConnectClient = new ConnexionManagerClientImplSOAP(easiergovConnexionManager);
                    ConnectToEnvironment connectToEnvironment = new ConnectToEnvironment();
                    for (Map.Entry entry : result.getEsbNodes().entrySet()) {
                        connectToEnvironment.setEndpointAddress((String)entry.getKey());
                        ConnectToEnvironmentResponse connectResponse = easiergovConnectClient.connectToEnvironment(connectToEnvironment);
                        EventManagerClientImplSOAP easiergovEventClient = new EventManagerClientImplSOAP(easiergovEventManager);
                        System.out.println("esb.getKey() = " + (String)entry.getKey());
                        AdminClientImplSOAP adminEsbClient = new AdminClientImplSOAP((String)entry.getKey());
                        adminEsbClient.connectToGovernance(easiergovEventManager);
                    }
                }
                for (Map.Entry entry : result.getBsmNodes().entrySet()) {
                    for (String string : result.getEventCloudNodes().keySet()) {
                        System.out.println("ppppppppppppppppp connect bsm " + (String)entry.getKey() + " to event cloud " + string);
                        BSMAdminClientImplSOAP bsmclient = new BSMAdminClientImplSOAP((String)entry.getKey());
                        try {
                            bsmclient.connectToEsb(string, new Boolean(false));
                        }
                        catch (AdminExceptionMsg e) {
                            throw new CloudManagementException("Failed to connect bsm with event cloud", (Throwable)e);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static File createTemporaryFile(InputStream is) {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            File tmpFile = FileUtils.createTempFile((String)UUID.randomUUID().toString(), (String)".txt");
            br = new BufferedReader(new InputStreamReader(is));
            bw = new BufferedWriter(new FileWriter(tmpFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.write(10);
            }
            bw.flush();
            File file = tmpFile;
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

