/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.cep.launcher;

import com.ebmwebsourcing.cep.launcher.ConfigurationImpl;
import com.ebmwebsourcing.cep.launcher.Launcher;
import com.ebmwebsourcing.cep.launcher.util.CommandReader;
import com.ebmwebsourcing.cep.launcher.util.Locker;
import com.ebmwebsourcing.cep.launcher.util.SystemExitHook;
import com.ebmwebsourcing.cep.server.Cep;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.LogManager;

public class CepWithEsperLauncher
implements Launcher {
    protected static final String START_COMMAND = "start";
    protected static final String SHUTDOWN_COMMAND = "shutdown";
    protected static final String VERSION_COMMAND = "version";
    protected String banner = " -----------------------------------------------------------\n|                                                           |\n|                          DiCEPE                           |\n|                                                           |\n -----------------------------------------------------------\n";
    protected static final String LOGGER_FILE = "/logger/Cep-logging.properties";
    protected Cep server;
    protected SystemExitHook systemExitHook;
    protected final Locker locker = new Locker(new File("."));

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("Cep is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("Cep is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.server);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new Exception("Can not start the Cep server, remove lock file from Cep root path or stop server");
        }
        this.locker.lock();
        ConfigurationImpl conf = new ConfigurationImpl();
        String host = conf.getHost();
        int port = conf.getPort();
        if (host == null || port <= 0) {
            throw new Exception("Wrong host or port parameters!!!");
        }
        this.server = new Cep("http://" + host + ":" + port + "/services/dicepe");
        System.out.println("CEP with Esper started at: http://" + host + ":" + port + "/services/dicepe");
        this.server.start();
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the CEP container");
        System.out.println(" -shutdowm               shutdown the CEP container");
        System.out.println(" -version                get the CEP container version");
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(Cep node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/Cep-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : CepWithEsperLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

