/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.GlowingIcon;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI {
    protected boolean iconGhostingMarker;
    protected Set lafWidgets;
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    private RolloverButtonListener substanceButtonListener;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        abstractButton.putClientProperty("icon.bounds", new Rectangle(rectangle));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GhostPaintingUtils.paintGhostIcon(graphics2D, abstractButton, rectangle);
        graphics2D.dispose();
        this.__org__jvnet__substance__SubstanceToggleButtonUI__icon__paintIcon(graphics, abstractButton, rectangle);
    }

    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceToggleButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceToggleButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceToggleButtonUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceToggleButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceToggleButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceToggleButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceToggleButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceToggleButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceToggleButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        ((AbstractButton)b).setRolloverEnabled(true);
        return new SubstanceToggleButtonUI();
    }

    public void __org__jvnet__substance__SubstanceToggleButtonUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        this.trackGlowingIcon(b);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
    }

    public void __org__jvnet__substance__SubstanceToggleButtonUI__uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void __org__jvnet__substance__SubstanceToggleButtonUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceButtonListener = new RolloverButtonListener(b);
        b.addMouseListener(this.substanceButtonListener);
        b.addMouseMotionListener(this.substanceButtonListener);
        b.addFocusListener(this.substanceButtonListener);
        b.addPropertyChangeListener(this.substanceButtonListener);
        b.addChangeListener(this.substanceButtonListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.buttonShaper".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(b);
                        }
                    });
                }
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceToggleButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceToggleButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceToggleButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
                    SubstanceToggleButtonUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceToggleButtonUI.this.trackGlowingIcon(b);
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b));
        this.substanceFadeStateListener.registerListeners();
    }

    protected void __org__jvnet__substance__SubstanceToggleButtonUI__uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.substanceButtonListener);
        b.removeMouseMotionListener(this.substanceButtonListener);
        b.removeFocusListener(this.substanceButtonListener);
        b.removePropertyChangeListener(this.substanceButtonListener);
        b.removeChangeListener(this.substanceButtonListener);
        this.substanceButtonListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners(b);
    }

    public void __org__jvnet__substance__SubstanceToggleButtonUI__update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        this.delegate.updateBackground(g, button);
        this.paint(g, c);
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted()) {
            return;
        }
        SubstanceCoreUtilities.paintFocus(g, b, b, null, textRect, 1.0f, 2 + SubstanceSizeUtils.getExtraPadding(b.getFont().getSize()));
    }

    protected void __org__jvnet__substance__SubstanceToggleButtonUI__icon__paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        Icon icon = SubstanceCoreUtilities.getIcon(b, this.glowingIcon, false);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, g));
        if (fadeTracker.isTracked(b, FadeKind.ROLLOVER)) {
            ComponentState state = ComponentState.getState(b.getModel(), b);
            if (state.isKindActive(FadeKind.ROLLOVER)) {
                SubstanceCoreUtilities.getIcon(b, this.glowingIcon, true).paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                b.getIcon().paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        SubstanceCoreUtilities.paintText(g, (AbstractButton)c, textRect, text, this.getTextShiftOffset(), this.getPropertyPrefix());
    }

    protected void trackGlowingIcon(AbstractButton b) {
        Icon currIcon = b.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, b);
    }
}

