/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.component.cos.impl;

import com.ebmwebsourcing.easierbsm.component.cos.api.COSComponent;
import com.ebmwebsourcing.easierbsm.component.cos.impl.COSComponentAdminBehaviourImpl;
import com.ebmwebsourcing.easierbsm.component.cos.impl.COSNotificationConsumerBehaviourImpl;
import com.ebmwebsourcing.easierbsm.component.cos.impl.env.ESBReceiverImpl;
import com.ebmwebsourcing.easierbsm.component.cos.impl.env.ESBSenderImpl;
import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easiercos.impl.COSFactoryImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.viper.behaviour.notification.impl.ViperComponentNotificationBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={COSComponent.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class COSComponentImpl
extends ComponentImpl<ComponentType>
implements COSComponent {
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    private Core core = null;

    public COSComponentImpl(QName name, ComponentType model, List<Class<? extends EndpointBehaviour>> behaviourClass, SOAElement<?> parent) throws ESBException {
        super(model, parent);
        this.createCore();
    }

    @Override
    public Core getCore() throws ESBException {
        if (this.core == null) {
            this.createCore();
        }
        return this.core;
    }

    private void createCore() throws ESBException {
        try {
            this.log.finest("Core Intialization...");
            ConfigurationEngineImpl conf = new ConfigurationEngineImpl();
            this.core = COSFactoryImpl.getInstance().newCOSEngine(1, ESBReceiverImpl.class, 1, ESBSenderImpl.class);
            SCAHelper.getSCAHelper().addComponent(this.core.getComponent(), this.getComponent(), null);
            NodeBehaviour nodeBehaviour = (NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class);
            this.addBehaviourClass(COSComponentAdminBehaviourImpl.class);
            this.addBehaviourClass(COSNotificationConsumerBehaviourImpl.class);
            this.addBehaviourClass(ViperComponentNotificationBehaviourImpl.class);
            this.core.getExternalEnvironment().setHost(nodeBehaviour.getHost());
            SoapServer soapServer = (SoapServer)nodeBehaviour.getExternalServer("soap-server");
            if (soapServer != null) {
                this.core.getExternalEnvironment().setPort(String.valueOf(soapServer.getPort()));
            }
        }
        catch (COSException e) {
            this.log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (Exception e) {
            this.log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
    }

    public Object getContext() {
        try {
            return this.getCore();
        }
        catch (ESBException e) {
            this.log.warning("Failed to retrieve context for the COS component (core)");
            return null;
        }
    }
}

