/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.component.cos.impl.env;

import com.ebmwebsourcing.easierbsm.component.cos.impl.message.ESBContextImpl;
import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.w3c.dom.Element;

@Scope(value="COMPOSITE")
@Service(value={Sender.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ESBSenderImpl
extends AbstractSenderImpl
implements Sender {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ESBSenderImpl.class.getName());
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private ExternalContext externalcontext = null;

    public void sendTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context, boolean isReply) throws CoreException {
        ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
        try {
            log.finest("Asynchronous send: PROVIDER ENDPOINT NAME: " + address);
            if (message != null) {
                log.finest("MESSAGE SENT BY COS ENGINE: \n" + message);
            } else {
                org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element elmt = doc.createElement("null");
                doc.appendChild(elmt);
                message = new MessageImpl("dummyOperation");
                DOMBuilder domBuilder = new DOMBuilder();
                message.getBody().setPayload(domBuilder.build(doc.getDocumentElement()));
                log.finest("MESSAGE SENT BY COS ENGINE: \n" + message);
            }
            ProcessKeyImpl pk = new ProcessKeyImpl(null, message.getService(), message.getEndpoint());
            List processes = this.getExternalEnvironment().getEngine().getProcessInstanceRegistry().getProcessInstances((ProcessKey)pk);
            log.finest("send to partner: " + message.getEndpoint());
            ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
            Exchange ex = providerEp.createExchange();
            URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(message.getService(), message.getEndpoint(), new QueryParam[0]));
            ex.setDestinationReference(epr);
            ex.setOperation(new QName(message.getInterface().getNamespaceURI(), message.getOperationName()).toString());
            ex.setInterfaceName(message.getInterface());
            ex.setPattern(PatternType.IN_ONLY);
            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            msgIn.setBody(body);
            ex.setMessageIn(msgIn);
            DOMOutputter converter = new DOMOutputter();
            org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
            ex.getMessageIn().getBody().setPayload(domDocument);
            providerEp.send(ex);
        }
        catch (ParserConfigurationException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (COSException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (ExchangeException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (TransportException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (JDOMException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public Message sendSyncTo(Message message, String providerEndpoint, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        block12: {
            ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
            try {
                log.finest("Synchronous send: PROVIDER ENDPOINT NAME: " + providerEndpoint);
                if (message != null) {
                    log.finest("MESSAGE SENT SYNC BY COS engine: \n" + message);
                } else {
                    org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    Element elmt = doc.createElement("null");
                    doc.appendChild(elmt);
                    message = new MessageImpl("dummyOperation");
                    DOMBuilder domBuilder = new DOMBuilder();
                    message.getBody().setPayload(domBuilder.build(doc.getDocumentElement()));
                    log.finest("MESSAGE SENT BY COS ENGINE: \n" + message);
                }
                ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                Exchange ex = providerEp.createExchange();
                URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(message.getService(), message.getEndpoint(), new QueryParam[0]));
                ex.setDestinationReference(epr);
                ex.setOperation(new QName(message.getService().getNamespaceURI(), message.getOperationName()).toString());
                ex.setInterfaceName(message.getInterface());
                ex.setPattern(PatternType.IN_OUT);
                MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
                Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                msgIn.setBody(body);
                ex.setMessageIn(msgIn);
                DOMOutputter converter = new DOMOutputter();
                org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
                ex.getMessageIn().getBody().setPayload(domDocument);
                ex = providerEp.sendSync(ex, new Long(0L).longValue());
                if (ex.getMessageError() == null || ex.getMessageError().getBody() == null || ex.getMessageError().getBody().getPayload() == null) {
                    if (message != null) {
                        log.finest("MESSAGE RECEIVED BY COS engine: \n" + message);
                    } else {
                        log.finest("MESSAGE RECEIVED BY COS engine: \n" + message);
                    }
                    break block12;
                }
                MessageImpl faultMsg = new MessageImpl(ex.getOperation());
                DOMBuilder builder = new DOMBuilder();
                if (ex.getMessageError().getBody().getPayload() != null) {
                    Document faultJDoc = builder.build(ex.getMessageError().getBody().getPayload());
                    log.finest("fault on bpel send: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(faultJDoc));
                    faultMsg.getBody().setPayload(faultJDoc.getRootElement());
                }
                faultMsg.setEndpoint(ex.getDestinationReference().toString());
                faultMsg.setService(message.getService());
                CoreException userEx = new CoreException();
                userEx.setFault((Message)faultMsg);
                throw userEx;
            }
            catch (ParserConfigurationException e) {
                log.warning("Error on invoke: " + e.getMessage());
                throw new CoreException((Throwable)e);
            }
            catch (COSException e) {
                log.warning("Error on invoke: " + e.getMessage());
                throw new CoreException((Throwable)e);
            }
            catch (ExchangeException e) {
                log.warning("Error on invoke: " + e.getMessage());
                throw new CoreException((Throwable)e);
            }
            catch (TransportException e) {
                log.warning("Error on invoke: " + e.getMessage());
                throw new CoreException((Throwable)e);
            }
            catch (JDOMException e) {
                log.warning("Error on invoke: " + e.getMessage());
                throw new CoreException((Throwable)e);
            }
        }
        return message;
    }

    public void sendTo(CoreException e, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        try {
            ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
            Exchange exchange = esbContext.getInitialExchange();
            log.warning("Send error: " + exchange.getPattern());
            if (PatternType.IN_OUT.equals((Object)exchange.getPattern())) {
                log.warning("Send technical fault: \n" + (Object)((Object)e));
                e.printStackTrace();
                org.jdom.Element internalMsg = null;
                log.warning("mmmmmmmmmm e.getFault(): \n" + e.getFault());
                if (e.getFault() != null) {
                    internalMsg = e.getFault().getBody().getPayload();
                }
                DOMOutputter converter = new DOMOutputter();
                log.warning("internalMsg = " + internalMsg);
                if (internalMsg != null) {
                    org.w3c.dom.Document domDocument = converter.output(internalMsg.getDocument());
                    log.warning("fault on bpel send 2: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(internalMsg));
                    if (exchange.getMessageError() == null) {
                        MessageError msgError = (MessageError)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                        exchange.setMessageError(msgError);
                    }
                    if (exchange.getMessageError().getBody() == null) {
                        Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                        exchange.getMessageError().setBody(body);
                    }
                    exchange.getMessageError().getBody().setPayload(domDocument);
                }
                ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                log.finest("providerEp = " + providerEp);
                exchange.setStatus(StatusType.FAULT);
                providerEp.sendResponseToClient(exchange);
            }
        }
        catch (JDOMException e1) {
            throw new CoreException((Throwable)e1);
        }
        catch (TransportException e1) {
            throw new CoreException((Throwable)e1);
        }
    }

    public ExternalContext getExternalcontext() {
        return this.externalcontext;
    }

    public void setExternalcontext(ExternalContext externalcontext) {
        this.externalcontext = externalcontext;
    }
}

