/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.base.monitoring;

import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicSetType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

public class DataCollectorTest {
    private Node createDataCollectorNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"data-collector-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    @Test(timeout=1200000L)
    public void dataCollectorTest() throws ESBException {
        Node node = this.createDataCollectorNode(new QName("http://www.petalslink.com", "DataCollector"), "localhost", 9001, 8094);
        try {
            node.stop();
        }
        catch (TransportException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void dataCollectorConnectTest() throws TransportException, ESBException, ConnectToEsbFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault, ResourceUnknownFault {
        Node dataCollector = null;
        Node esb = null;
        try {
            esb = this.createNode(new QName("http://www.petalslink.com", "esb"), "localhost", 9000, 8094);
            dataCollector = this.createDataCollectorNode(new QName("http://www.petalslink.com", "DataCollector"), "localhost", 9001, 8095);
            URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(esb.getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
            DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)dataCollector.findBehaviour(NodeBehaviour.class)).getComponent(epr);
            ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb("http://localhost:8094/services/adminExternalEndpoint");
            AdminClientImplSOAP esbAdmin = new AdminClientImplSOAP("http://localhost:8094/services/adminExternalEndpoint");
            EJaxbGetResourcePropertyResponse response = esbAdmin.getResourceProperty(new QName("http://docs.oasis-open.org/wsn/t-1", "TopicSet"));
            JAXBElement topicSet = (JAXBElement)response.getAny().get(0);
            Assert.assertEquals((int)2, (int)((EJaxbTopicSetType)topicSet.getValue()).getAny().size());
        }
        finally {
            if (dataCollector != null) {
                dataCollector.stop();
            }
        }
    }
}

