/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.interceptor.report;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.soa.impl.test.util.EchoBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.interceptor.report.ReportIntializationInterceptor;
import com.ebmwebsourcing.easierbsm.wsdm.interceptor.timestamp.TimeStamper;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import easybox.petalslink.com.esrawreport._1.ObjectFactory;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import service.ebmwebsourcing.com.rawreport.RawReportInterfaceImpl;
import service.ebmwebsourcing.com.rawreport.RawReportInterface_RawReportEndpoint_Server;

public class ReportInterceptorTest {
    private static Logger log = Logger.getLogger(ReportInterceptorTest.class.getName());
    private static final String RAW_REPORT_ENDPOINT = "http://localhost:8200/rawReportEndpointClientProxyEndpoint";
    private EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);

    public ReportInterceptorTest() throws Exception {
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, boolean explorer, String host, int port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl();
        ConfigurationImpl conf = new ConfigurationImpl(explorer, host, port, new ExternalServer[]{new SoapServer(new SoapServerConfig(8184))});
        conf.addProperty("wsdm-endpoint-creation-service-address", "http://localhost:8200/services/wsdmEndpointCrerationServiceEndpoint");
        conf.addProperty("rawreport-service-address", RAW_REPORT_ENDPOINT);
        System.out.println("ReportIntializationInterceptor.class.getName() = " + ReportIntializationInterceptor.class.getName());
        conf.addEndpointInitializationInterceptorClassName(ReportIntializationInterceptor.class.getName());
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronousInOutSend() throws Exception {
        boolean explorer = false;
        Node node = null;
        RawReportInterface_RawReportEndpoint_Server rawReportServiceMock = null;
        try {
            node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), explorer, "localhost", 9001);
            Component component = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(new QName("http://com.ebmwebsourcing.easyesb", "SOAPWorld"), ComponentImpl.class);
            Service service = ((ComponentBehaviour)component.findBehaviour(ComponentBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/wheather", "weather"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myWeatherEndpoint", ProviderEndpointImpl.class, this.context);
            providerEndpoint.addBehaviourClass(EchoBehaviour.class);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/wheather", "myClientWheatherEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context);
            rawReportServiceMock = new RawReportInterface_RawReportEndpoint_Server(RAW_REPORT_ENDPOINT);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestination(providerEndpoint.getQName());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo").toString());
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory.class});
            Echo_Type echo = new Echo_Type();
            echo.setIn("hello world!!!");
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo));
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("msg In = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageIn().printMessage()));
            System.out.println("msg out = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().printMessage()));
            log.info("msg In = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageIn().printMessage()));
            log.info("msg out = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().printMessage()));
            Assert.assertEquals((Object)"hello world!!!", (Object)response.getMessageOut().getBody().getPayload().getDocumentElement().getFirstChild().getFirstChild().getNodeValue());
            Assert.assertNotNull((Object)response.getMessageIn().getHeader().getProperty(TimeStamper.DATE_CLIENT_IN_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageIn().getHeader().getProperty(TimeStamper.DATE_PROVIDER_IN_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageOut().getHeader().getProperty(TimeStamper.DATE_CLIENT_OUT_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageOut().getHeader().getProperty(TimeStamper.DATE_PROVIDER_OUT_PROPERTY));
            long time = 0L;
            long start = Calendar.getInstance().getTimeInMillis();
            long end = 0L;
            while (((RawReportInterfaceImpl)rawReportServiceMock.getImplementor()).getReportList().size() < 2 && time < 10000L) {
                end = Calendar.getInstance().getTimeInMillis();
                time = end - start;
            }
            System.out.println();
            List<EJaxbReportListType> reports = ((RawReportInterfaceImpl)rawReportServiceMock.getImplementor()).getReportList();
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            QName tag = new QName("http://com.petalslink/esrawreport/1.0", "ReportListType");
            int i = 0;
            for (EJaxbReportListType rep : reports) {
                Document doc = SOAJAXBContext.getInstance().unmarshallAnyType(tag, (Object)rep, EJaxbReportListType.class);
                System.out.println("########" + i + "#########\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                ++i;
            }
            Assert.assertEquals((long)2L, (long)reports.size());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            if (rawReportServiceMock != null) {
                rawReportServiceMock.shutdown();
            }
        }
    }
}

