/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.interceptor.report;

import com.ebmwebsourcing.easierbsm.wsdm.interceptor.report.AbstractReportInterceptor;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.logging.Logger;

public class ClientReportInterceptor
extends AbstractReportInterceptor
implements ClientEndpointInvocationInterceptor {
    private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());
    private Configuration conf;

    public ClientReportInterceptor(Configuration conf) {
        this.conf = conf;
    }

    public void processingExchangeAfterReceiving(Exchange exchange) throws TransportException {
        String address = (String)this.conf.getProperties().get("rawreport-service-address");
        log.finest("t4: report interception to be sent at " + address + " for exchange " + exchange.getUuid());
        if (address != null) {
            if (address.trim().length() == 0) {
                address = null;
            }
            if (exchange != null) {
                log.finest("t4: report exchange not null");
                if (address != null) {
                    log.finest("t4: report address not null");
                    ReportList reports = this.createReportListFromExchangeT3T4(exchange);
                    log.finest("t4: reports created ");
                    if (reports.getReports().length > 0) {
                        log.finest("t4: reports sent ...");
                        this.sendReport(reports, address);
                    }
                }
            } else {
                log.severe("ERROR: TIMEOUT => Impossible to create report");
            }
        }
    }

    public void processingExchangeBeforeSending(Exchange exchange) throws TransportException {
    }
}

