/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.interceptor.report;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.interceptor.report.AbstractReportInterceptor;
import com.ebmwebsourcing.easierbsm.wsdm.interceptor.report.ClientReportInterceptor;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class ProviderReportInterceptor
extends AbstractReportInterceptor
implements ProviderEndpointInvocationInterceptor {
    private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());
    private Configuration conf;

    public ProviderReportInterceptor(Configuration conf) {
        this.conf = conf;
    }

    public void processingExchangeBeforeSending(Exchange ex) throws TransportException {
    }

    public void processingExchangeAfterReceiving(Exchange exchange) throws TransportException {
        log.finest("t2: report interception");
        Document sourNodeInfo = exchange.getMessageIn().getHeader().getProperty(SourceNodeInformations.QNAME);
        SourceNodeInformations sourNodeInfoModel = null;
        try {
            sourNodeInfoModel = (SourceNodeInformations)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(sourNodeInfo, SourceNodeInformations.class);
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            log.warning("Failed to retrieve sourceNodeInformation to get services Information");
        }
        if (sourNodeInfoModel != null) {
            String address = "http://" + sourNodeInfoModel.getHost() + ":" + sourNodeInfoModel.getPort();
            log.finest("t2: report address unusued ? " + address);
        }
        String addressForReport = (String)this.conf.getProperties().get("rawreport-service-address");
        log.finest("t2: report address used " + addressForReport + " exchange " + exchange.getUuid());
        if (addressForReport != null) {
            if (addressForReport.trim().length() == 0) {
                addressForReport = null;
            }
            if (exchange != null) {
                log.finest("t2: report exchange not null");
                if (addressForReport != null) {
                    log.finest("t2: report address not null");
                    ReportList reports = this.createReportListFromExchangeT1T2(exchange);
                    log.finest("t2: reports created");
                    if (reports.getReports().length > 0) {
                        log.finest("t2: reports sent ...");
                        this.sendReport(reports, addressForReport);
                    }
                }
            } else {
                log.severe("ERROR: TIMEOUT => Impossible to create report");
            }
        }
    }
}

