/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.base.monitoring;

import com.ebmwebsourcing.easierbsm.base.monitoring.util.NotificationConsumerMock;
import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.WSDMComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.MonitoringException;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.network.NetworkHelper;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.ws.test.stockquotes.StockQuoteSoap_StockQuoteSoap_Server;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.XmlException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.LogManager;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import net.webservicex.StockQuoteSoap;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MonitoringTest {
    DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

    private void setReport(ReportType report) throws DatatypeConfigurationException {
        report.setConsumerEndpointAddress("consumerClientEndpoint");
        report.setContentLength(new Random().nextLong());
        report.setDateInGMT(GregorianCalendar.getInstance().getTime());
        report.setDoesThisResponseIsAnException(false);
        report.setEndpointName("providerEndpoint");
        report.setOperationName("operationNameOfService");
        report.setServiceQName(new QName("serviceNameOfProvider"));
        report.setProviderEndpointAddress("ProviderName");
    }

    private Node createMonitoringNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"data-collector-factory", "wsdm-monitoring-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCreationAndSubscriptionToWSDMEndpoint() throws Exception {
        StockQuoteSoap_StockQuoteSoap_Server stockQuoteService = null;
        Node functionalBus = null;
        Node monitoringBus = null;
        try {
            stockQuoteService = new StockQuoteSoap_StockQuoteSoap_Server("http://localhost:9301/StockQuoteEndpoint");
            functionalBus = this.createNode(new QName("http://petals.ow2.org", "EasyBus"), "localhost", 9100, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9101, 8085);
            this.createEnvironement(monitoringBus);
            UserManagementClientSOAP client = new UserManagementClientSOAP("http://localhost:8085/services/StockQuoteSoap_WSDMMonitoringClientProxyEndpoint");
            QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "mows-ev");
            Subscribe subscribe = WSNHelper.createSubscription((String)"http://localhost:9002/NotificationEndpoint", (QName)topicUsed, (QName[])new QName[0]);
            EJaxbSubscribeResponse response = client.subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribe));
            Assert.assertNotNull((Object)response);
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
                assert (((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (functionalBus != null) {
                functionalBus.stop();
                assert (((NodeBehaviour)functionalBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (stockQuoteService != null) {
                stockQuoteService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=45000L)
    public void testCreation_Subscription_NotificationToWSDMEndpoint() throws Exception {
        StockQuoteSoap_StockQuoteSoap_Server stockQuoteService = null;
        Node functionalBus = null;
        Node monitoringBus = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            stockQuoteService = new StockQuoteSoap_StockQuoteSoap_Server("http://localhost:9301/StockQuoteEndpoint");
            functionalBus = this.createNode(new QName("http://petals.ow2.org", "EasyBus"), "localhost", 9100, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9101, 8085);
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, "http://localhost:9002/NotificationEndpoint");
            this.createEnvironement(monitoringBus);
            UserManagementClientSOAP client = new UserManagementClientSOAP("http://localhost:8085/services/StockQuoteSoap_WSDMMonitoringClientProxyEndpoint");
            QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "mows-ev");
            Subscribe subscribe = WSNHelper.createSubscription((String)"http://localhost:9002/NotificationEndpoint", (QName)topicUsed, (QName[])new QName[0]);
            EJaxbSubscribeResponse response = client.subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribe));
            Assert.assertNotNull((Object)response);
            StockQuoteSoap functionalClient = (StockQuoteSoap)CXFHelper.getClient((String)"http://localhost:8084/services/StockQuoteSoapClientProxyEndpoint", StockQuoteSoap.class);
            String responseStock = functionalClient.getQuote("ebm");
            Assert.assertNotNull((Object)responseStock);
            while (notifier.getNotifications().size() == 0) {
                Thread.sleep(5000L);
                System.out.println("Wait notification!!!");
            }
            Assert.assertEquals((int)1, (int)notifier.getNotifications().size());
            EJaxbNotify notif = notifier.getNotifications().get(0);
            EJaxbNotificationMessageHolderType.Message message = ((EJaxbNotificationMessageHolderType)notif.getNotificationMessage().get(0)).getMessage();
            Element e = (Element)((Element)message.getAny()).cloneNode(true);
            Document doc = this.db.newDocument();
            e = (Element)doc.adoptNode(e);
            doc.appendChild(e);
            OperationMetrics metric = (OperationMetrics)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, OperationMetrics.class);
            System.out.println(metric);
            Assert.assertEquals((Object)new Long(1L), (Object)metric.getNumberOfRequests().getValue());
            Assert.assertEquals((Object)new Long(1L), (Object)metric.getNumberOfSuccessfulRequests().getValue());
            Assert.assertEquals((Object)new Long(0L), (Object)metric.getNumberOfFailedRequests().getValue());
            Assert.assertNotNull((Object)metric.getMaxResponseSize().getValue());
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
                assert (((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (functionalBus != null) {
                functionalBus.stop();
                assert (((NodeBehaviour)functionalBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (stockQuoteService != null) {
                stockQuoteService.shutdown();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }

    private void createEnvironement(Node monitoringBus) throws Exception {
        URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
        DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
        ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb("http://localhost:8084/services/adminExternalEndpoint");
        URI wsdmEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null, new QueryParam[0]));
        WSDMMonitoringEngine wsdmMonitoringEngine = (WSDMMonitoringEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(wsdmEpr);
        ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).connectToDataCollector();
        AdminClientImpl adminClient = new AdminClientImpl("http://localhost:8084/services/adminExternalEndpoint");
        String consumerSoapAddress = adminClient.wrapSoapEndpoint("http://localhost:9301/StockQuoteEndpoint", new URL("http://localhost:9301/StockQuoteEndpoint?wsdl").toString(), null);
        System.out.println("++++++++++++++++++++++++++ consumerSoapAddress = " + consumerSoapAddress);
        Thread.sleep(200L);
        List res = ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).getAllMonitoringEndpoints();
        System.out.println("getAllMonitoringEndpoints response: " + res);
        while (res != null && res.size() == 0) {
            System.out.println("getAllMonitoringEndpoints response: " + res);
            res = ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).getAllMonitoringEndpoints();
            Thread.sleep(500L);
        }
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((int)1, (int)res.size());
        Assert.assertEquals((String)MonitoringEndpointType.class.getName(), (String)((MonitoringEndpointType)res.get(0)).getClass().getName());
        MonitoringEndpointType met = (MonitoringEndpointType)res.get(0);
        Assert.assertEquals((String)"StockQuoteSoap_WSDMMonitoring", (String)met.getName().getLocalPart());
        Thread.sleep(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMonitoringDescription() throws MonitoringException, NoSuchInterfaceException, InterruptedException, XmlException, ESBException, TransportException, URISyntaxException, SAXException, IOException, ParserConfigurationException, SOAException {
        boolean explorer = false;
        Node monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
        try {
            URI wsdmEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null, new QueryParam[0]));
            WSDMMonitoringEngine wSDMMonitoringEngine = (WSDMMonitoringEngine)((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(wsdmEpr);
            WSDMService monitoringService = wSDMMonitoringEngine.createMonitoringService(new QName("http://petals.ow2.org", "stockquoteServiceMonitoring"));
            WSDMProviderEndpoint monitoringProviderEndpoint = monitoringService.createMonitoringEndpoint("stockquoteEndpointMonitoring");
            EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
            context.setNumberOfThreads(5);
            ClientProxyEndpoint clientEndpoint = (ClientProxyEndpoint)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://petals.ow2.org/echo/", "echoSOAPExternal"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, context, new ListenerInitialisation[0]);
            EndpointAddress addr = ESBUtil.analyzeURI((URI)monitoringProviderEndpoint.getReference());
            clientEndpoint.setProviderServiceName(new QName(addr.getNamespace(), addr.getServicename()));
            clientEndpoint.setProviderEndpointName(addr.getEndpointname());
            Description desc = clientEndpoint.getDescription();
            Assert.assertNotNull((Object)desc);
            Assert.assertNotNull((Object)desc.getBindings());
            Assert.assertEquals((int)3, (int)desc.getBindings().size());
        }
        finally {
            monitoringBus.stop();
        }
    }

    public void end() {
        if (NetworkHelper.oneOfPortsOpen((int[])new int[]{8085, 8084, 8385, 8386, 9100})) {
            Assert.fail();
        }
    }

    private boolean isPortUsed(int port) {
        try {
            ServerSocket port6553 = new ServerSocket(port);
            port6553.close();
            return false;
        }
        catch (IOException e) {
            System.out.println("Could not bind to port " + port + ". Another process may own it.");
            return true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

