/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.base.monitoring;

import com.ebmwebsourcing.easierbsm.base.monitoring.util.NotificationConsumerMock;
import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.WSDMComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.network.NetworkHelper;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.ws.test.stockquotes.StockQuoteSoap_StockQuoteSoap_Server;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.LogManager;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Assert;
import net.webservicex.IsBusyRequest;
import net.webservicex.IsBusyResponse;
import net.webservicex.StockQuoteSoap;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WithBusinessMonitoringTest {
    DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

    private void setReport(ReportType report) throws DatatypeConfigurationException {
        report.setConsumerEndpointAddress("consumerClientEndpoint");
        report.setContentLength(new Random().nextLong());
        report.setDateInGMT(GregorianCalendar.getInstance().getTime());
        report.setDoesThisResponseIsAnException(false);
        report.setEndpointName("providerEndpoint");
        report.setOperationName("operationNameOfService");
        report.setServiceQName(new QName("serviceNameOfProvider"));
        report.setProviderEndpointAddress("ProviderName");
    }

    private Node createMonitoringNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"data-collector-factory", "wsdm-monitoring-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void testCreation_Subscription_NotificationToWSDMEndpoint() throws Exception {
        StockQuoteSoap_StockQuoteSoap_Server stockQuoteService = null;
        Node functionalBus = null;
        Node monitoringBus = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            stockQuoteService = new StockQuoteSoap_StockQuoteSoap_Server("http://localhost:9301/StockQuoteEndpoint");
            functionalBus = this.createNode(new QName("http://petals.ow2.org", "EasyBus"), "localhost", 9100, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9101, 8085);
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, "http://localhost:9002/NotificationEndpoint");
            this.createEnvironement(monitoringBus);
            UserManagementClientSOAP client = new UserManagementClientSOAP("http://localhost:8085/services/StockQuoteSoap_WSDMMonitoringClientProxyEndpoint");
            QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "mows-ev");
            Subscribe subscribe = WSNHelper.createSubscription((String)"http://localhost:9002/NotificationEndpoint", (QName)topicUsed, (QName[])new QName[0]);
            EJaxbSubscribeResponse response = client.subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribe));
            Assert.assertNotNull((Object)response);
            URI wsdmEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null, new QueryParam[0]));
            WSDMMonitoringEngine wsdmComponent = (WSDMMonitoringEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(wsdmEpr);
            String functionalEsbNode = "http://localhost:8084/services/adminExternalEndpoint";
            URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
            DataCollectorEngine dataCollector = (DataCollectorEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
            ((DataCollectorEngineBehaviour)dataCollector.findBehaviour(DataCollectorEngineBehaviour.class)).addEsbNode(functionalEsbNode);
            wsdmComponent.activateBusinessMonitoring(new QName("http://www.webserviceX.NET/", "StockQuote"), "StockQuoteSoap", new ArrayList());
            StockQuoteSoap functionalClient = (StockQuoteSoap)CXFHelper.getClient((String)"http://localhost:8084/services/StockQuoteSoapClientProxyEndpoint", StockQuoteSoap.class);
            IsBusyRequest parameters = new IsBusyRequest();
            IsBusyResponse responseStock = functionalClient.isBusy(parameters);
            Assert.assertNotNull((Object)responseStock);
            while (notifier.getNotifications().size() == 0) {
                Thread.sleep(5000L);
                System.out.println("Wait notification!!!");
            }
            Assert.assertEquals((int)1, (int)notifier.getNotifications().size());
            EJaxbNotify notif = notifier.getNotifications().get(0);
            EJaxbNotificationMessageHolderType.Message message = ((EJaxbNotificationMessageHolderType)notif.getNotificationMessage().get(0)).getMessage();
            Element e = (Element)((Element)message.getAny()).cloneNode(true);
            Document doc = this.db.newDocument();
            e = (Element)doc.adoptNode(e);
            doc.appendChild(e);
            System.out.println("MESSAGE:\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            Assert.assertTrue((boolean)XMLPrettyPrinter.prettyPrint((Document)doc).contains("StockQuote is quiteBusy"));
            OperationMetrics metric = (OperationMetrics)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, OperationMetrics.class);
            System.out.println(metric);
            Assert.assertEquals((Object)new Long(1L), (Object)metric.getNumberOfRequests().getValue());
            Assert.assertEquals((Object)new Long(1L), (Object)metric.getNumberOfSuccessfulRequests().getValue());
            Assert.assertEquals((Object)new Long(0L), (Object)metric.getNumberOfFailedRequests().getValue());
            Assert.assertNotNull((Object)metric.getMaxResponseSize().getValue());
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
                assert (((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (functionalBus != null) {
                functionalBus.stop();
                assert (((NodeBehaviour)functionalBus.findBehaviour(NodeBehaviour.class)).isStopped());
            }
            if (stockQuoteService != null) {
                stockQuoteService.shutdown();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }

    private void createEnvironement(Node monitoringBus) throws Exception {
        URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
        DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
        ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb("http://localhost:8084/services/adminExternalEndpoint");
        URI wsdmEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null, new QueryParam[0]));
        WSDMMonitoringEngine wsdmMonitoringEngine = (WSDMMonitoringEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(wsdmEpr);
        ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).connectToDataCollector();
        AdminClientImpl adminClient = new AdminClientImpl("http://localhost:8084/services/adminExternalEndpoint");
        String consumerSoapAddress = adminClient.wrapSoapEndpoint("http://localhost:9301/StockQuoteEndpoint", new URL("http://localhost:9301/StockQuoteEndpoint?wsdl").toString(), null);
        System.out.println("++++++++++++++++++++++++++ consumerSoapAddress = " + consumerSoapAddress);
        Thread.sleep(200L);
        List res = ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).getAllMonitoringEndpoints();
        System.out.println("getAllMonitoringEndpoints response: " + res);
        while (res != null && res.size() == 0) {
            System.out.println("getAllMonitoringEndpoints response: " + res);
            res = ((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).getAllMonitoringEndpoints();
            Thread.sleep(500L);
        }
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((int)1, (int)res.size());
        Assert.assertEquals((String)MonitoringEndpointType.class.getName(), (String)((MonitoringEndpointType)res.get(0)).getClass().getName());
        MonitoringEndpointType met = (MonitoringEndpointType)res.get(0);
        Assert.assertEquals((String)"StockQuoteSoap_WSDMMonitoring", (String)met.getName().getLocalPart());
        Thread.sleep(1000L);
    }

    public void end() {
        if (NetworkHelper.oneOfPortsOpen((int[])new int[]{8085, 8084, 8385, 8386, 9100})) {
            Assert.fail();
        }
    }

    private boolean isPortUsed(int port) {
        try {
            ServerSocket port6553 = new ServerSocket(port);
            port6553.close();
            return false;
        }
        catch (IOException e) {
            System.out.println("Could not bind to port " + port + ". Another process may own it.");
            return true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

