/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.test.behaviour.memb;

import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easiercos.api.EasierCOSFramework;
import com.ebmwebsourcing.easiercos.impl.COSFactoryImpl;
import com.ebmwebsourcing.easiercos.impl.message.COSExternalMessageImpl;
import com.ebmwebsourcing.easiercos.impl.message.COSInternalMessageImpl;
import com.ebmwebsourcing.easiercos.impl.message.DefaultCOSMessageConverter;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.easycommons.explorer.ExplorerFrame;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class MEMBTest {
    DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

    @Test
    public void testCompilMEMB() throws CoreException {
        boolean enactExplorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        if (env == null) {
            System.out.println("env is null");
            Assert.fail((String)"env is null");
        }
        Core core = COSFactoryImpl.getInstance().newCOSEngine(DefaultCOSMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        try {
            ProcessDefinitionRegistry registry = core.getModel().getRegistry();
            Thread.currentThread().getContextClassLoader();
            registry.storeProcessDefinition(ClassLoader.getSystemResource("echo/EchoProcessBPMN.xml").toURI(), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
            junit.framework.Assert.assertEquals((int)1, (int)registry.getAllProcessDefinitions().size());
            junit.framework.Assert.assertEquals((int)1, (int)core.getEngine().getProcessInstanceRegistry().getProcessInstances().size());
            if (enactExplorer) {
                ExplorerFrame explorer = new ExplorerFrame(((Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0)).getComponent());
                explorer.setVisible(true);
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
        catch (SCAException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    @Test(timeout=17000L)
    public void testRawReportMEMB() {
        boolean enactExplorer = false;
        try {
            ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
            if (env == null) {
                System.out.println("env is null");
                Assert.fail((String)"env is null");
            }
            Core core = COSFactoryImpl.getInstance().newCOSEngine(DefaultCOSMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
            env.setCore(core);
            ProcessDefinitionRegistry registry = core.getModel().getRegistry();
            Thread.currentThread().getContextClassLoader();
            registry.storeProcessDefinition(ClassLoader.getSystemResource("echo/EchoProcessBPMN.xml").toURI(), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
            junit.framework.Assert.assertEquals((int)1, (int)registry.getAllProcessDefinitions().size());
            junit.framework.Assert.assertEquals((int)1, (int)core.getEngine().getProcessInstanceRegistry().getProcessInstances().size());
            org.w3c.dom.Document notifPayload = this.db.parse(new File(Thread.currentThread().getContextClassLoader().getResource("rawreportmessages/reportT1T2Echo.xml").toURI()));
            Notify request = MEMBTest.createNotification("provider", "consumer", "uid", new QName("topic"), "dialect", notifPayload);
            org.w3c.dom.Document doc = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(request);
            COSExternalMessageImpl cosmessage = new COSExternalMessageImpl();
            DOMBuilder b = new DOMBuilder();
            Document jdom = b.build(doc);
            cosmessage.setContent((Object)jdom.getRootElement());
            COSInternalMessageImpl cosInternalMessageT1T2 = this.createCOSInternalMessageImpl("rawreportmessages/reportT1T2Echo.xml");
            COSInternalMessageImpl cosInternalMessageT3T4 = this.createCOSInternalMessageImpl("rawreportmessages/reportT3T4Echo.xml");
            ExternalContext externalContext = null;
            if (enactExplorer) {
                ExplorerFrame explorer = new ExplorerFrame(((Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0)).getComponent());
                explorer.setVisible(true);
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            core.getEngine().accept((InternalMessage)cosInternalMessageT1T2, externalContext);
            Thread.sleep(500L);
            core.getEngine().accept((InternalMessage)cosInternalMessageT3T4, externalContext);
            while (!((Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0)).getState().equals((Object)Process.State.PROCESS_ENDED)) {
                Thread.sleep(200L);
            }
            System.out.println(((Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0)).getState());
            junit.framework.Assert.assertEquals((Object)Process.State.PROCESS_ENDED, (Object)((Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0)).getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    public COSInternalMessageImpl createCOSInternalMessageImpl(String requestResource) throws SAXException, IOException, URISyntaxException, WsnbException, CoreException {
        org.w3c.dom.Document notifPayload = this.db.parse(new File(Thread.currentThread().getContextClassLoader().getResource(requestResource).toURI()));
        Notify request = MEMBTest.createNotification("provider", "consumer", "uid", new QName("topic"), "dialect", notifPayload);
        org.w3c.dom.Document doc = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(request);
        COSExternalMessageImpl cosmessage = new COSExternalMessageImpl();
        DOMBuilder b = new DOMBuilder();
        Document jdom = b.build(doc);
        cosmessage.setContent((Object)jdom.getRootElement());
        DefaultCOSMessageConverter c = new DefaultCOSMessageConverter(COSExternalMessageImpl.class, COSInternalMessageImpl.class);
        COSInternalMessageImpl cosInternalMessage = (COSInternalMessageImpl)c.createInternalMessageFromExternalMessage((ExternalMessage)cosmessage);
        return cosInternalMessage;
    }

    public static Notify createNotification(String producerAddress, String endpointAddress, String uuid, QName topicUsed, String dialect, org.w3c.dom.Document notifPayload) throws COSException {
        Notify notifyPayload = null;
        try {
            Address address;
            NotificationMessageHolderType.Message mess = null;
            mess = notifPayload != null ? RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement()) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(null);
            NotificationMessageHolderType msg = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(mess);
            notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);
            if (topicUsed != null) {
                TopicExpressionType notifyTopicExpr = MEMBTest.createTopicExpression(topicUsed, dialect);
                msg.setTopic(notifyTopicExpr);
            }
            if (endpointAddress != null && uuid != null) {
                EndpointReferenceType registrationRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)EasierCOSFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
                address = (Address)SOAUtil.getInstance().getXmlContext((Framework)EasierCOSFramework.getInstance()).getXmlObjectFactory().create(Address.class);
                address.setValue(URI.create(endpointAddress));
                registrationRef.setAddress(address);
                ReferenceParameters ref = (ReferenceParameters)SOAUtil.getInstance().getXmlContext((Framework)EasierCOSFramework.getInstance()).getXmlObjectFactory().create(ReferenceParameters.class);
                registrationRef.setReferenceParameters(ref);
                msg.setSubscriptionReference(registrationRef);
            }
            EndpointReferenceType producerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlContext((Framework)EasierCOSFramework.getInstance()).getXmlObjectFactory().create(EndpointReferenceType.class);
            address = (Address)SOAUtil.getInstance().getXmlContext((Framework)EasierCOSFramework.getInstance()).getXmlObjectFactory().create(Address.class);
            address.setValue(URI.create(producerAddress));
            producerRef.setAddress(address);
            msg.setProducerReference(producerRef);
        }
        catch (WsnbException e) {
            throw new COSException((Throwable)e);
        }
        return notifyPayload;
    }

    public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws COSException {
        TopicExpressionType notifyTopicExpr = null;
        try {
            notifyTopicExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(URI.create(dialect));
            if (topicUsed.getPrefix() == null) {
                throw new COSException("prefix of topicUsed cannot be null");
            }
            notifyTopicExpr.addTopicNamespace(topicUsed.getPrefix(), URI.create(topicUsed.getNamespaceURI()));
            notifyTopicExpr.setContent(topicUsed.getPrefix() + ":" + topicUsed.getLocalPart());
        }
        catch (WsnbException e) {
            throw new COSException((Throwable)e);
        }
        return notifyTopicExpr;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }
}

