/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.impl;

import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easiercos.api.COSFactory;
import com.ebmwebsourcing.easiercos.api.inout.COSReader;
import com.ebmwebsourcing.easiercos.impl.compiler.COSCompilerImpl;
import com.ebmwebsourcing.easiercos.impl.inout.COSReaderImpl;
import com.ebmwebsourcing.easiercos.impl.registry.COSMemoryRegistryImpl;
import com.ebmwebsourcing.easiercos.impl.validation.COSStaticAnalysisImpl;
import com.ebmwebsourcing.easiercos.impl.validation.COSStaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.factory.Factory;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.impl.CoreImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.ModelImpl;
import com.ebmwebsourcing.easyviper.extended.service.notification.impl.ExtendedServiceNotificationImpl;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={Factory.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class COSFactoryImpl
extends COSFactory
implements Factory {
    private static COSFactory instance = null;

    private COSFactoryImpl() {
    }

    public static COSFactory getInstance() {
        if (instance == null) {
            instance = new COSFactoryImpl();
        }
        return instance;
    }

    public COSReader newCOSReader() throws COSException {
        COSReaderImpl reader = new COSReaderImpl();
        return reader;
    }

    public Core newCOSEngine(int numberOfReceivers, Class<? extends Receiver> receiverClass, int numberOfSenders, Class<? extends Sender> senderClass) throws COSException {
        return this.newCOSEngine((ConfigurationEngine)new ConfigurationEngineImpl(), numberOfReceivers, receiverClass, numberOfSenders, senderClass, null);
    }

    private Core newCOSEngine(ConfigurationEngine conf, int numberOfReceivers, Class<? extends Receiver> receiverClass, int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws COSException {
        Core core;
        try {
            core = this.createCore((ConfigurationEngine)((ConfigurationEngineImpl)conf), numberOfReceivers, receiverClass, numberOfSenders, senderClass, logger);
            core.getModel().getRegistry().setStaticAnalysis((StaticAnalysis)COSStaticAnalysisImpl.getInstance());
            core.getModel().getRegistry().setStaticAnalysisPrinter((StaticAnalysisPrinter)COSStaticAnalysisPrinter.getInstance());
        }
        catch (CoreException e) {
            throw new COSException((Throwable)e);
        }
        return core;
    }

    public Core createCore(ConfigurationEngine configuration, int numberOfReceivers, Class<? extends Receiver> receiverClass, int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws CoreException {
        Core core = super.createCore(COSFactory.DEFAULT_NAME, configuration, CoreImpl.class);
        if (logger != null) {
            core.setLog(logger);
        }
        Engine engine = core.createEngine(configuration);
        Model model = core.createModel("COSModel", ModelImpl.class);
        Compiler compiler = model.createCompiler("COSCompiler", COSCompilerImpl.class);
        ProcessDefinitionRegistry registry = model.createRegistry("COSRegistry", COSMemoryRegistryImpl.class);
        ExternalEnvironment externalEnvironment = core.createExternalEnvironment("COSEnvironment");
        int i = 0;
        while (i < numberOfReceivers) {
            externalEnvironment.addReceiver(receiverClass);
            ++i;
        }
        i = 0;
        while (i < numberOfSenders) {
            externalEnvironment.addSender(senderClass);
            ++i;
        }
        core.getEngine().getServiceManager().addService(ExtendedServiceNotificationImpl.class);
        return core;
    }
}

