/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.impl.behaviour.monitoring;

import com.ebmwebsourcing.easiercos.api.EasierCOSFramework;
import com.ebmwebsourcing.easiercos.api.behaviour.monitoring.MessageExchangeMonitoringBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.DOMOutputter;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;
import org.w3c.dom.Node;

@Scope(value="COMPOSITE")
@Service(value={MessageExchangeMonitoringBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class MessageExchangeMonitoringBehaviourImpl
extends ReceiverBehaviourImpl
implements MessageExchangeMonitoringBehaviour {
    private Logger log = Logger.getLogger(MessageExchangeMonitoringBehaviourImpl.class.getCanonicalName());
    private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();
    @Property(name="operation", required=true)
    private String operation;
    @Property(name="providerInterface", required=true)
    private QName providerInterface;
    private String exchangeId = null;
    @Property(name="expectedProviderEndpoint", required=true)
    private QName expectedProviderEndpoint;
    @Property(name="expectedConsumerEndpoint", required=true)
    private QName expectedConsumerEndpoint;
    @Property(name="isInOut", required=true)
    private boolean isInOut;
    @Property(name="waitForT3T4", required=true)
    private boolean waitForT3T4;

    public boolean accept(Execution execution, Message message) throws CoreException {
        ReportList request;
        block22: {
            block21: {
                block19: {
                    block20: {
                        org.w3c.dom.Element content;
                        block18: {
                            List messagesList;
                            block17: {
                                Object activityName = null;
                                org.w3c.dom.Document doc = null;
                                System.out.println("message.getBody().getPayload().getContent().get(0) = " + message.getBody().getPayload().getContent().get(0).getClass());
                                if (message.getBody().getPayload() instanceof org.w3c.dom.Document) {
                                    doc = (org.w3c.dom.Document)message.getBody().getPayload();
                                } else if (message.getBody().getPayload() instanceof Element) {
                                    DOMOutputter outputter = new DOMOutputter();
                                    Document jdom = new Document();
                                    Element root = (Element)message.getBody().getPayload().detach();
                                    jdom.setRootElement(root);
                                    doc = outputter.output(jdom);
                                }
                                System.out.println("notif: \n" + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)doc));
                                Notify notify = RefinedWsnbFactory.getInstance().getWsnbReader().readNotify(doc);
                                messagesList = notify.getNotificationMessage();
                                if (messagesList != null && messagesList.size() != 0) break block17;
                                this.log.info("No payload found in this notification...");
                                return false;
                            }
                            request = null;
                            content = ((NotificationMessageHolderType)messagesList.get(0)).getMessage().getAny();
                            if (content != null) break block18;
                            return false;
                        }
                        org.w3c.dom.Document rawReportdom = this.db.newDocument();
                        Node contentNode = rawReportdom.adoptNode(content);
                        if (contentNode != null) {
                            rawReportdom.appendChild(contentNode);
                            request = (ReportList)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierCOSFramework.getInstance()).get()).readDocument(rawReportdom, ReportList.class);
                        }
                        if (this.exchangeId == null) {
                            this.exchangeId = request.getReports()[0].getExchangeId();
                            break block19;
                        }
                        if (this.exchangeId.equals(request.getReports()[0].getExchangeId())) break block20;
                        return false;
                    }
                    if (request.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t3)) break block19;
                    return false;
                }
                this.log.finest("RawReport not null" + request);
                this.log.info("check reports for the " + this.getName() + "choreography task.");
                if (request.getReports()[0].getProviderEndpointAddress().equals(this.expectedProviderEndpoint.toString())) break block21;
                return false;
            }
            String consumer = request.getReports()[0].getConsumerEndpointAddress();
            QName consumerQName = this.inferQName(consumer, request);
            if (consumerQName != null) {
                consumer = consumerQName.toString();
            }
            if (consumer.equals(this.expectedConsumerEndpoint.toString())) break block22;
            return false;
        }
        try {
            if (!request.getReports()[0].getInterfaceQName().equals(this.providerInterface)) {
                return false;
            }
        }
        catch (WsnbException e) {
            this.log.warning("Notification reading failed... This message is not a (WS-)Notify.");
            return false;
        }
        catch (Exception e) {
            throw new CoreException((Throwable)e);
        }
        if (this.waitForT3T4) {
            execution.setState(Execution.State.SUSPENDED);
        }
        this.waitForT3T4 = false;
        return true;
    }

    private QName inferQName(String consumer, ReportList request) {
        int indexOfPrefixSplitter = consumer.indexOf(":");
        if (indexOfPrefixSplitter > 0) {
            String prefix = consumer.substring(0, indexOfPrefixSplitter);
            String namespace = (String)request.getXmlObjectInScopeNamespaces().get(prefix);
            return new QName(namespace, consumer.substring(indexOfPrefixSplitter + 1, consumer.length()));
        }
        return null;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }
}

