/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.impl.compiler;

import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easiercos.api.compiler.COSCompiler;
import com.ebmwebsourcing.easiercos.api.compiler.COSDefinition;
import com.ebmwebsourcing.easiercos.api.inout.COSReader;
import com.ebmwebsourcing.easiercos.impl.COSFactoryImpl;
import com.ebmwebsourcing.easiercos.impl.behaviour.monitoring.MessageExchangeMonitoringBehaviourImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Choreography;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ChoreographyTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParallelGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.w3c.dom.Document;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={COSCompiler.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class COSCompilerImpl
extends AbstractCompiler<COSDefinition>
implements COSCompiler {
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());
    COSReader reader = COSFactoryImpl.getInstance().newCOSReader();
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public COSCompilerImpl() throws COSException {
        this.factory.setNamespaceAware(true);
    }

    public Process compile(COSDefinition processDefinition) throws CoreException {
        Process process = null;
        if (processDefinition == null || processDefinition.getDefinitions() == null || processDefinition.getDefinitions().getChoreographies() == null || processDefinition.getDefinitions().getChoreographies().length == 0) {
            throw new CoreException("BPMN choreography model can't be null ...");
        }
        Choreography[] choreographyArray = processDefinition.getDefinitions().getChoreographies();
        int n = choreographyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Choreography cosProcess = choreographyArray[n2];
            QName cosProcessQName = new QName(processDefinition.getDefinitions().getTargetNamespace(), processDefinition.getDefinitions().getName());
            QName cosProcessUniqueQName = new QName(cosProcessQName + "_" + System.nanoTime());
            process = this.getModel().getCore().getEngine().createNewEmptyProcessInstance(cosProcessUniqueQName, (ProcessDefinition)processDefinition);
            FlowNode[] initialNodes = this.extractInitialNodes(cosProcess.getFlowNode());
            if (initialNodes.length == 0) {
                this.log.warning("Empty choreography !!!");
                return process;
            }
            if (initialNodes.length > 1) {
                throw new RuntimeException("TO DO: NOT YET IMPLEMENTED");
            }
            this.generateSequence(process, cosProcess, initialNodes[0], processDefinition);
            ++n2;
        }
        return process;
    }

    private void generateSequence(Process process, Choreography cosProcess, FlowNode flowNode, COSDefinition processDefinition) throws CoreException {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        for (FlowNode childFlowNode : flowNode.getOutgoingFlowNodes()) {
            Node viperNode = this.generateNode(childFlowNode, (Scope)process, processDefinition);
            childNodes.add(viperNode);
        }
        Node mainSequence = CreationPatternFactory.getInstance().createSequencePattern("MainSequence", childNodes, (Scope)process);
        process.setInitialNode(mainSequence);
    }

    private Node generateNode(FlowNode node, Scope process, COSDefinition processDefinition) throws CoreException {
        Node res = null;
        if (node instanceof ChoreographyTask) {
            ChoreographyTask nodeChoreography = (ChoreographyTask)node;
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            Participant initiatingParticipant = processDefinition.getDefinitions().getChoreographies()[0].getParticipant(nodeChoreography.getInitiatingParticipantRef().getLocalPart());
            QName initiatingParticipantEndpointRef = initiatingParticipant.getEndPointRef()[0];
            QName initiatingParticipantEndpoint = processDefinition.getDefinitions().getEndpointById(initiatingParticipantEndpointRef.getLocalPart()).getEndPointRef();
            Participant providerParticipant = null;
            QName providerEndpoint = null;
            QName[] participants = nodeChoreography.getParticipantRef();
            String endpointRef = nodeChoreography.getInitiatingParticipantRef().getLocalPart();
            QName[] qNameArray = participants;
            int n = participants.length;
            int n2 = 0;
            while (n2 < n) {
                QName p = qNameArray[n2];
                if (!p.getLocalPart().equals(endpointRef)) {
                    providerParticipant = processDefinition.getDefinitions().getChoreographies()[0].getParticipant(p.getLocalPart());
                    providerEndpoint = processDefinition.getDefinitions().getEndpointById(providerParticipant.getEndPointRef()[0].getLocalPart()).getEndPointRef();
                }
                ++n2;
            }
            String interfaceRef = providerParticipant.getInterfaceRef()[0].getLocalPart();
            Interface[] interfaces = processDefinition.getDefinitions().getInterfaces();
            QName interfaceQName = null;
            Interface[] interfaceArray = interfaces;
            int n3 = interfaces.length;
            int n4 = 0;
            while (n4 < n3) {
                Interface i = interfaceArray[n4];
                if (interfaceRef.equals(i.getId())) {
                    interfaceQName = i.getImplementationRef();
                }
                ++n4;
            }
            boolean waitT3T4 = false;
            if (nodeChoreography.getMessageFlowRef().length > 1) {
                waitT3T4 = true;
            }
            context.put("expectedProviderEndpoint", providerEndpoint);
            context.put("expectedConsumerEndpoint", initiatingParticipantEndpoint);
            context.put("providerInterface", interfaceQName);
            context.put("waitForT3T4", Boolean.valueOf(waitT3T4));
            res = process.createNode(node.getName(), MessageExchangeMonitoringBehaviourImpl.class, context);
        } else {
            if (node instanceof ExclusiveGateway) {
                throw new RuntimeException("TO DO: NOT YET IMPLEMENTED");
            }
            if (node instanceof ParallelGateway) {
                throw new RuntimeException("TO DO: NOT YET IMPLEMENTED");
            }
        }
        return res;
    }

    private void generateFlow(Process process, Choreography cosProcess, FlowNode[] initialNodes) {
    }

    private FlowNode[] extractInitialNodes(FlowNode[] flowNodes) {
        ArrayList<FlowNode> res = new ArrayList<FlowNode>();
        if (flowNodes != null) {
            int i = 0;
            while (i < flowNodes.length) {
                if (flowNodes[i].getIncomingFlowNodes() == null || flowNodes[i].getIncomingFlowNodes().size() == 0) {
                    res.add(flowNodes[i]);
                }
                ++i;
            }
        }
        return res.toArray(new FlowNode[res.size()]);
    }

    public COSDefinition validate(URI uri) throws CoreException {
        COSDefinition cosdefinition = null;
        try {
            Document cosSrcDoc;
            URL url = null;
            InputStream is = null;
            url = uri.isAbsolute() ? uri.toURL() : new URL(new File(".").toURI().toURL(), uri.toString());
            is = url.openStream();
            Document costargetDoc = cosSrcDoc = this.factory.newDocumentBuilder().parse(is);
            if (costargetDoc.getDocumentURI() == null) {
                costargetDoc.setDocumentURI(url.toString().replaceAll(" ", "%20"));
            }
            cosdefinition = this.reader.readCOS(costargetDoc);
        }
        catch (Exception e) {
            throw new CoreException((Throwable)e);
        }
        return cosdefinition;
    }
}

