/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.impl.inout;

import com.ebmwebsourcing.easiercos.api.COSException;
import com.ebmwebsourcing.easiercos.api.compiler.COSDefinition;
import com.ebmwebsourcing.easiercos.api.inout.COSReader;
import com.ebmwebsourcing.easiercos.impl.compiler.COSDefinitionImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class COSReaderImpl
implements COSReader {
    private static Logger log = Logger.getLogger(COSReaderImpl.class.getName());
    private Map<COSReader.FeatureConstants, Object> features = new HashMap<COSReader.FeatureConstants, Object>();

    public COSReaderImpl() throws COSException {
        this.features.put(COSReader.FeatureConstants.VERBOSE, false);
        this.features.put(COSReader.FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    public void setFeature(COSReader.FeatureConstants name, Object value) throws COSException {
    }

    public Object getFeature(COSReader.FeatureConstants name) {
        return null;
    }

    public Map<COSReader.FeatureConstants, Object> getFeatures() {
        return null;
    }

    public COSDefinition readCOS(URI cosURI) throws COSException {
        COSDefinition desc = null;
        try {
            InputStream input = null;
            File f = new File(cosURI.toString());
            input = f.exists() ? new FileInputStream(f) : cosURI.toURL().openStream();
            desc = this.readCOS(cosURI, new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new COSException("Can not get bpel at: " + cosURI, (Throwable)e);
        }
        catch (IOException e) {
            throw new COSException("Can not get bpel at: " + cosURI, (Throwable)e);
        }
        catch (COSException e) {
            throw new COSException("Can not get bpel at: " + cosURI, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new COSException("Can not get bpel at: " + cosURI, (Throwable)e);
        }
        return desc;
    }

    public COSDefinition readCOS(Document cosDocument) throws COSException {
        COSDefinition desc = null;
        try {
            URI uri = null;
            uri = cosDocument.getDocumentURI() != null ? new URI(cosDocument.getDocumentURI()) : new File(".").toURI();
            desc = this.readCOS(uri, SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(cosDocument)));
        }
        catch (URISyntaxException e) {
            throw new COSException((Throwable)e);
        }
        catch (XmlException e) {
            throw new COSException((Throwable)e);
        }
        return desc;
    }

    public COSDefinition readCOS(URI cosURI, InputSource inputSource) throws COSException {
        COSDefinitionImpl desc = null;
        try {
            desc = new COSDefinitionImpl(cosURI.toURL());
        }
        catch (MalformedURLException e) {
            throw new COSException((Throwable)e);
        }
        return desc;
    }
}

