/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiercos.impl.registry;

import com.ebmwebsourcing.easiercos.api.compiler.COSDefinition;
import com.ebmwebsourcing.easiercos.api.registry.COSRegistry;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={COSRegistry.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class COSMemoryRegistryImpl
extends AbstractProcessDefinitionRegistry<ProcessDefinition>
implements COSRegistry {
    final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());

    public ProcessDefinition getProcessDefinition(ProcessKey name) {
        return (ProcessDefinition)this.registry.get(name);
    }

    public List<ProcessDefinition> getAllProcessDefinitions() {
        return new ArrayList<ProcessDefinition>(this.registry.values());
    }

    public COSDefinition removeProcessDefinition(ProcessKey name, boolean forceUninstall) throws CoreException {
        COSDefinition res = null;
        this.log.finest("Map of instance: " + ((MemoryProcessInstanceRegistryImpl)this.getModel().getCore().getEngine().getProcessInstanceRegistry()).getMap());
        Iterator it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
        ArrayList<Process> undeleteProcess = new ArrayList<Process>();
        while (it.hasNext()) {
            Process p;
            Process process = (Process)it.next();
            if (forceUninstall) {
                this.log.finest("remove process instance: " + process.getName());
                p = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance: process is null: " + process.getName());
                continue;
            }
            if (process.getExecution() != null && process.getExecution().getState() == Execution.State.ENDED || process.getExecution() == null) {
                this.log.finest("remove process instance: " + process.getName());
                p = this.getModel().getCore().getEngine().getProcessInstanceRegistry().removeProcessInstance(process, forceUninstall);
                if (p != null) {
                    it = this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances(name).iterator();
                    continue;
                }
                this.log.warning("Impossible to delete instance, try forceuninstall=true: " + process.getName());
                continue;
            }
            if (undeleteProcess.contains(process)) continue;
            undeleteProcess.add(process);
        }
        if (undeleteProcess.size() > 0) {
            String errorMsg = "";
            for (Process process : undeleteProcess) {
                errorMsg = String.valueOf(errorMsg) + "Impossible to remove this process instance" + process.getName() + " because it is not ended: state = " + process.getExecution().getState() + "\n";
            }
            throw new CoreException(errorMsg);
        }
        res = (COSDefinition)this.registry.remove(name);
        return res;
    }

    public <D extends ProcessDefinition> boolean isCreateInstance(D def, Message mess) throws CoreException {
        return false;
    }

    public List<ProcessKey> createKeys(ProcessDefinition processDefinition) throws CoreException {
        ArrayList<ProcessKey> lprocessKey = new ArrayList<ProcessKey>();
        ProcessKeyImpl pk = new ProcessKeyImpl();
        pk.setInterface(processDefinition.getQName());
        lprocessKey.add((ProcessKey)pk);
        return lprocessKey;
    }
}

