/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.events;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.fireman.test.Fireman_NotificationProducer_Server;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.events.EventProducerResourceType;
import com.petalslink.easiergov.events.EventsManagerImpl;
import com.petalslink.easiergov.events.EventsProducerAndTopicNameSpaceAnalyzerServiceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1.ResourceIdentifier;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;
import easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EventManagerImplTest {
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);
    private ObjectFactory topicFactory = new ObjectFactory();
    private EventsManager eventsAPI = null;
    private CoreManagerImpl coreManager = null;
    private Node node = null;

    @Before
    public void setup() throws GovException, ESBException {
        this.coreManager = new CoreManagerImpl((com.petalslink.easiergov.config.Configuration)new ConfigurationImpl());
        this.node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        this.eventsAPI = new EventsManagerImpl((ResourcesManager)this.coreManager.getResourcesManager());
    }

    @After
    public void tearDown() throws GovException, TransportException {
        if (this.node != null) {
            this.node.stop();
        }
        this.coreManager.clear();
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronize_UsecaseCrisis_UsingSubscription() throws Exception {
        Fireman_NotificationProducer_Server firemanEventProducer_WSOUIServer = null;
        try {
            firemanEventProducer_WSOUIServer = new Fireman_NotificationProducer_Server("http://localhost:9211/FiremanSOAPEventProducer");
            firemanEventProducer_WSOUIServer.start();
            this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
            ConnectToEnvironment request = new ConnectToEnvironment();
            request.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse response = this.coreManager.getConnexionManager().connectToEnvironment(request);
            Assert.assertNotNull((Object)response.getExecutionEnvironmentInformation());
            this.coreManager.getConnexionManager().synchronize();
            AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");
            String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
            String consumerSoapAddress = client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
            Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            while (this.coreManager.getResourcesManager().getAllByResourceType((ResourceType)EventProducerResourceType.getInstance()).size() == 0 && end - start < 20000000L) {
                Thread.sleep(200L);
                end = System.currentTimeMillis();
            }
            System.out.println("Storage :\n" + this.coreManager.getResourcesManager());
            Assert.assertEquals((long)1L, (long)this.coreManager.getResourcesManager().getAllByResourceType((ResourceType)EventProducerResourceType.getInstance()).size());
        }
        finally {
            if (firemanEventProducer_WSOUIServer != null) {
                firemanEventProducer_WSOUIServer.stop();
            }
        }
    }

    public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(URL url) throws PublishTopicNamespaceFromURLFault, GovException {
        PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
        request.setTopicNamespaceUrl(url.toString());
        PublishTopicNamespaceFromURLResponse response = this.eventsAPI.publishTopicNamespaceFromURL(request);
        return response;
    }

    public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(URL url) throws PublishTopicNamespaceFromDOMFault, GovException, SAXException, IOException, ParserConfigurationException, SOAException {
        PublishTopicNamespaceFromDOM request = new PublishTopicNamespaceFromDOM();
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(url.openStream());
        EJaxbTopicNamespaceType tns = (EJaxbTopicNamespaceType)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbTopicNamespaceType.class);
        request.setTopicNamespace((EJaxbTopicNamespaceType)this.topicFactory.createTopicNamespace(tns).getValue());
        PublishTopicNamespaceFromDOMResponse response = this.eventsAPI.publishTopicNamespaceFromDOM(request);
        return response;
    }

    @Test
    public void test_PublishTopicNameSpaceFromURL() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromURLResponse response = this.publishTopicNamespaceFromURL(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/crisis-events-topicsNS.xml"));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getResourceIdentifier().size());
        Assert.assertEquals((Object)"{http://www.soceda.org/crisis}CrisisEvents", (Object)((ResourceIdentifier)response.getResourceIdentifier().get(0)).getId().toString());
        Assert.assertEquals((Object)"topic-namespace", (Object)((ResourceIdentifier)response.getResourceIdentifier().get(0)).getResourceType());
    }

    @Test
    public void test_PublishTopicNameSpaceFromDOM() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromDOMResponse response = this.publishTopicNamespaceFromDOM(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/crisis-events-topicsNS.xml"));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getResourceIdentifier().size());
        Assert.assertEquals((Object)"{http://www.soceda.org/crisis}CrisisEvents", (Object)((ResourceIdentifier)response.getResourceIdentifier().get(0)).getId().toString());
        Assert.assertEquals((Object)"topic-namespace", (Object)((ResourceIdentifier)response.getResourceIdentifier().get(0)).getResourceType());
    }

    @Test
    public void test_findTopicsByElement() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromURLResponse response = this.publishTopicNamespaceFromURL(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/crisis-events-topicsNS.xml"));
        List topics = this.eventsAPI.findTopicsByElement(new QName("http://www.soceda.org/crisis/v1/deliver_iodine/Fireman/", "cardiacRythm"));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)topics.size());
        Assert.assertEquals((Object)"{http://www.soceda.org/crisis}cardiacRythmFiremanTopic", (Object)((QName)topics.get(0)).toString());
    }

    @Test
    public void test_findTopics() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromURLResponse response = this.publishTopicNamespaceFromURL(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/crisis-events-topicsNS.xml"));
        List topics = this.eventsAPI.findTopics("cardiac");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)topics.size());
        Assert.assertEquals((Object)"{http://www.soceda.org/crisis}cardiacRythmFiremanTopic", (Object)((EJaxbTopicType)topics.get(0)).getName());
    }

    @Test
    public void test_findAllTopics_FromCrisisTNS() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromURLResponse response = this.publishTopicNamespaceFromURL(Thread.currentThread().getContextClassLoader().getResource("crisis/EventTopicNS.xml"));
        List topics = this.eventsAPI.findTopics("");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)4L, (long)topics.size());
        for (EJaxbTopicType t : topics) {
            Assert.assertTrue((t.getMessageTypes().size() > 0 ? 1 : 0) != 0);
            System.out.println(t.getName() + "=>" + t.getMessageTypes().toString());
        }
    }

    @Test
    public void test_findAllTopics() throws Exception {
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
        PublishTopicNamespaceFromURLResponse response = this.publishTopicNamespaceFromURL(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/crisis-events-topicsNS.xml"));
        List topics = this.eventsAPI.findTopics("");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)3L, (long)topics.size());
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

