/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.events;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.fireman.test.Fireman_NotificationProducer_Server;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.events.EventProducerResourceType;
import com.petalslink.easiergov.events.EventsManagerImpl;
import com.petalslink.easiergov.events.EventsProducerAndTopicNameSpaceAnalyzerServiceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.resources_api._1_0.ResourcesManager;
import easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class FindByTopicsTest {
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);
    private ObjectFactory topicFactory = new ObjectFactory();
    private EventsManager eventsAPI = null;
    private CoreManagerImpl coreManager = null;
    private Node node = null;

    @Before
    public void setup() throws GovException, ESBException {
        this.coreManager = new CoreManagerImpl((com.petalslink.easiergov.config.Configuration)new ConfigurationImpl());
        this.node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        this.eventsAPI = new EventsManagerImpl((ResourcesManager)this.coreManager.getResourcesManager());
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    @After
    public void tearDown() throws GovException, TransportException {
        if (this.node != null) {
            this.node.stop();
        }
        this.coreManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void test_findEventProducersByTopics() throws Exception {
        Fireman_NotificationProducer_Server firemanEventProducer_WSOUIServer = null;
        try {
            firemanEventProducer_WSOUIServer = new Fireman_NotificationProducer_Server("http://localhost:9211/FiremanSOAPEventProducer");
            firemanEventProducer_WSOUIServer.start();
            this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            this.coreManager.getResourcesManager().addResourceAnalyzerService((AbstractResourceAnalyzerService)new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());
            ConnectToEnvironment requestConnect = new ConnectToEnvironment();
            requestConnect.setEndpointAddress("http://localhost:8095/services/adminExternalEndpoint");
            ConnectToEnvironmentResponse responseConnect = this.coreManager.getConnexionManager().connectToEnvironment(requestConnect);
            Assert.assertNotNull((Object)responseConnect.getExecutionEnvironmentInformation());
            this.coreManager.getConnexionManager().synchronize();
            Thread.sleep(2000L);
            AdminClientImplSOAP client = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");
            String soapAddress = "http://localhost:9211/FiremanSOAPEventProducer";
            String consumerSoapAddress = client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/Fireman.wsdl").toExternalForm(), null);
            Assert.assertEquals((Object)"http://localhost:8095/services/FiremanSOAPEventProducerClientProxyEndpoint", (Object)consumerSoapAddress);
            while (this.coreManager.getResourcesManager().getAllByResourceType((ResourceType)EventProducerResourceType.getInstance()).size() == 0) {
                Thread.sleep(1000L);
                System.out.println("test_findEventProducersByTopics YOUYOU Storage :\n" + this.coreManager.getResourcesManager());
            }
            System.out.println("Storage :\n" + this.coreManager.getResourcesManager());
            Assert.assertEquals((long)1L, (long)this.coreManager.getResourcesManager().getAllByResourceType((ResourceType)EventProducerResourceType.getInstance()).size());
            FindEventProducersByTopicsRequest request = new FindEventProducersByTopicsRequest();
            request.getTopic().add(new QName("http://www.soceda.org/crisis", "cardiacRythmFiremanTopic"));
            FindEventProducersByTopicsResponse response = this.eventsAPI.findEventProducersByTopics(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.getEndpointReference().size());
            Assert.assertEquals((Object)"http://localhost:9211/FiremanSOAPEventProducer", (Object)((EJaxbEndpointReferenceType)response.getEndpointReference().get(0)).getAddress().getValue());
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyType(new QName("http://www.w3.org/2005/08/addressing", "EndpointReference"), response.getEndpointReference().get(0), EJaxbEndpointReferenceType.class);
            System.out.println("response = " + XMLPrettyPrinter.prettyPrint((Document)doc));
        }
        finally {
            if (firemanEventProducer_WSOUIServer != null) {
                firemanEventProducer_WSOUIServer.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

