/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api.analysis;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.analysis.AnalyzerException;
import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;
import com.ebmwebsourcing.easybox.api.analysis.ImplementationClassConstructorException;
import com.ebmwebsourcing.easybox.api.analysis.InterfaceClassMustBePublicException;
import com.ebmwebsourcing.easybox.api.analysis.MultipleInterfacesImplementedException;
import com.ebmwebsourcing.easybox.api.analysis.UnexpectedImplementationKindException;
import com.ebmwebsourcing.easybox.api.analysis.UnexpectedPublicImplementationException;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public final class Analyzer {
    private static final String SUFFIXE_TYPE_PACKAGE = ".type";
    private final XmlObjectBinding xmlObjectBinding;
    private final ClassMetadata classMetadata;

    public Analyzer(XmlObjectBinding xmlObjectBinding, ClassMetadata classMetadata) {
        this.xmlObjectBinding = xmlObjectBinding;
        this.classMetadata = classMetadata;
    }

    public void analyze() throws AnalyzerException {
        for (Class xmlObjectNodeImplClass : this.xmlObjectBinding.getFactorableClasses()) {
            this.classMetadata.put(xmlObjectNodeImplClass, "implementationClassBinding", (Object)this.xmlObjectBinding);
            this.analyzeClass(xmlObjectNodeImplClass);
            Class xmlObjectNodeInterfaceClass = (Class)this.classMetadata.get(xmlObjectNodeImplClass, "implementationClassInterface");
            this.classMetadata.put(xmlObjectNodeInterfaceClass, "interfaceClassBinding", (Object)this.xmlObjectBinding);
        }
    }

    void analyzeClass(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws AnalyzerException {
        this.checkUnexpectedImplementationKind(xmlObjectNodeImplClass);
        this.checkUnexpectedPublicImplementation(xmlObjectNodeImplClass);
        this.checkMultipleInterfacesImplemented(xmlObjectNodeImplClass);
        this.checkInterfaceClassIsPublic(xmlObjectNodeImplClass);
        this.checkImplementationClassConstructor(xmlObjectNodeImplClass);
        this.checkConstantQName(xmlObjectNodeImplClass);
    }

    private void checkUnexpectedImplementationKind(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws UnexpectedImplementationKindException {
        if (xmlObjectNodeImplClass.isInterface()) {
            throw new UnexpectedImplementationKindException(xmlObjectNodeImplClass);
        }
    }

    private void checkUnexpectedPublicImplementation(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws UnexpectedPublicImplementationException {
    }

    private void checkMultipleInterfacesImplemented(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws MultipleInterfacesImplementedException {
        ArrayList interfacesExtendingXmlObject = new ArrayList();
        for (Class<?> interfaceClass : xmlObjectNodeImplClass.getInterfaces()) {
            if (!XmlObjectNode.class.isAssignableFrom(interfaceClass)) continue;
            interfacesExtendingXmlObject.add(interfaceClass);
        }
        if (interfacesExtendingXmlObject.size() != 1) {
            throw new MultipleInterfacesImplementedException(xmlObjectNodeImplClass);
        }
        this.classMetadata.put(xmlObjectNodeImplClass, "implementationClassInterface", interfacesExtendingXmlObject.get(0));
        this.classMetadata.put((Class)interfacesExtendingXmlObject.get(0), "interfaceClassImplementationClass", xmlObjectNodeImplClass);
    }

    private void checkInterfaceClassIsPublic(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws InterfaceClassMustBePublicException {
        Class interfaceClass = (Class)this.classMetadata.get(xmlObjectNodeImplClass, "implementationClassInterface");
        if (!Modifier.isPublic(interfaceClass.getModifiers())) {
            throw new InterfaceClassMustBePublicException(interfaceClass);
        }
    }

    private void checkImplementationClassConstructor(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) throws ImplementationClassConstructorException {
        Class<?> modelObjectClass = null;
        Constructor<?> foundConstructor = null;
        for (Constructor<?> constructor : xmlObjectNodeImplClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 2 && XmlContext.class.isAssignableFrom(parameterTypes[0]) && ModelObject.class.isAssignableFrom(parameterTypes[1])) {
                if (modelObjectClass != null) {
                    throw new ImplementationClassConstructorException(xmlObjectNodeImplClass);
                }
            } else {
                throw new ImplementationClassConstructorException(xmlObjectNodeImplClass);
            }
            foundConstructor = constructor;
            modelObjectClass = parameterTypes[1];
        }
        if (modelObjectClass == null) {
            throw new ImplementationClassConstructorException(xmlObjectNodeImplClass);
        }
        this.classMetadata.put(xmlObjectNodeImplClass, "implementationClassModelObjectClass", modelObjectClass);
        this.classMetadata.put(xmlObjectNodeImplClass, "implementationClassConstructor", foundConstructor);
    }

    private void checkConstantQName(Class<? extends XmlObjectNode> xmlObjectNodeImplClass) {
        try {
            Class interfaceClass = (Class)this.classMetadata.get(xmlObjectNodeImplClass, "implementationClassInterface");
            Field qnameField = interfaceClass.getField("QNAME");
            QName constantQName = (QName)qnameField.get(interfaceClass);
            this.classMetadata.put(interfaceClass, "interfaceClassConstantQName", (Object)constantQName);
            this.classMetadata.put(xmlObjectNodeImplClass, "implementationClassConstantQName", (Object)constantQName);
        }
        catch (SecurityException se) {
        }
        catch (NoSuchFieldException nsfe) {
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException("Illegal argument.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException("Illegal access.", (Throwable)e);
        }
    }
}

