/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.nfrbpmn;

import com.ebmwebsourcing.easiergov.nfrbpmn.NfrbpmnException;
import com.ebmwebsourcing.easiergov.nfrbpmn.NfrbpmnHelper;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.wsqdl.wsqdl10.api.element.Performance;
import com.ebmwebsourcing.wsstar.wspolicy15.api.anonymoustype.Policy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NfbpmnhelperTest {
    private static Policy policy;
    private static XmlContext xmlContext;
    private static XmlObjectWriter writer;

    @BeforeClass
    public static void init() {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        xmlContext = xmlContextFactory.newContext();
        policy = (Policy)xmlContext.getXmlObjectFactory().create(Policy.class);
    }

    @Test
    public void setPolicyInSendTaskTest() throws NfrbpmnException {
        SendTask sendTask = (SendTask)xmlContext.getXmlObjectFactory().create(SendTask.class);
        NfrbpmnHelper.setPolicy((XmlObject)sendTask, (Policy)policy);
        NfrbpmnHelper.getPolicy((XmlObject)sendTask);
        Assert.assertNotNull((Object)sendTask.getExtensionElements().getAnyXmlObjects(Policy.class));
        Assert.assertTrue((boolean)(policy instanceof XmlObject));
        int nbrPolicies = sendTask.getExtensionElements().getAnyXmlObjects(Policy.QNAME).length;
        Assert.assertEquals((long)1L, (long)nbrPolicies);
        Assert.assertEquals((Object)policy, (Object)sendTask.getExtensionElements().getAnyXmlObjects(Policy.QNAME)[0]);
    }

    @Test
    public void setPerformanceInPolicyTest() {
        Performance performance = (Performance)xmlContext.getXmlObjectFactory().create(Performance.class);
        try {
            NfrbpmnHelper.setPerformance((XmlObject)policy, (Performance)performance);
            String path = "target/resultPolicy.xml";
            writer.writeDocument((XmlObject)policy, (OutputStream)new FileOutputStream(new File(path)));
        }
        catch (NfrbpmnException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (XmlObjectWriteException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    static {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        xmlContext = xmlContextFactory.newContext();
        writer = xmlContext.createWriter();
    }
}

