/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.services;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.services.ServicesManagerImpl;
import com.petalslink.resources_api._1_0.ResourcesManager;
import com.petalslink.services_api._1.PublishWSDL;
import com.petalslink.services_api._1.PublishWSDLResponse;
import com.petalslink.services_api._1_0.FaultMessage;
import com.petalslink.services_api._1_0.ServicesManager;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.org.xmlsoap.schemas.wsdl.EJaxbTDefinitions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServicesImplTest {
    private ServicesManager servicesAPI = null;
    private ResourcesManagerImpl resourcesManager = null;

    @Before
    public void setup() throws GovException {
        this.resourcesManager = new ResourcesManagerImpl((Configuration)new ConfigurationImpl());
        this.servicesAPI = new ServicesManagerImpl((ResourcesManager)this.resourcesManager);
    }

    public List<EJaxbResourceIdentifier> publishWSDL(URL url) throws FaultMessage {
        PublishWSDL request = new PublishWSDL();
        request.setWsdlUrl(url.toString());
        PublishWSDLResponse response = this.servicesAPI.publishWSDL(request);
        return response.getResourceIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishService() throws FaultMessage, GovException {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishWSDL(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetServiceOnExistingService() throws GovException, FaultMessage {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<EJaxbResourceIdentifier> id = this.publishWSDL(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            EJaxbTDefinitions service = this.servicesAPI.getService(QName.valueOf(id.get(0).getId()));
            Assert.assertNotNull((Object)service);
            System.out.println("service.getName() = " + service.getName());
            Assert.assertEquals((Object)"firemen", (Object)service.getName());
            System.out.println("resources:\n" + this.resourcesManager);
            Assert.assertEquals((long)10L, (long)this.resourcesManager.getNumberOfResources());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetServiceOnNonExistingService() throws GovException, FaultMessage {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        QName id = new QName("http://wrong.services/", "unknownService");
        try {
            EJaxbTDefinitions service = this.servicesAPI.getService(id);
            Assert.fail();
        }
        catch (FaultMessage e) {
            Assert.assertEquals((Object)"Impossible to find service corresponding to this id: {http://wrong.services/}unknownService", (Object)e.getFaultInfo().getMessage());
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

