package com.ebmwebsourcing.easiergov.services.ui.server;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easiergov.services.ui.client.SearchServices;
import com.ebmwebsourcing.easiergov.services.ui.client.modelto.ServiceTO;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.petalslink.easiergov.services.ServicesImpl;
import com.petalslink.services_api._1.GetService;
import com.petalslink.services_api._1.GetServiceResponse;
import com.petalslink.services_api._1_0.GetServiceFault;
import com.petalslink.services_api._1_0.Services;
import com.petalslink.services_model._1.ServiceType;

public class SearchServicesImpl extends RemoteServiceServlet implements
SearchServices {

	private static final long serialVersionUID = 1L;

	@Override
	public List<ServiceTO> searchServices(String query) {
		List<ServiceTO> servicesTO = new ArrayList<ServiceTO>();

		// analyse query
		String[] queries = query.trim().split(" ");
		if(queries.length > 1) {
			// TODO: return error on query
		}
		
		
		Services servicesAPI = ServicesImpl.getInstance();
		GetService request = new GetService();
		request.setIdService(QName.valueOf(query));
		try {
			GetServiceResponse response = servicesAPI.getService(request);
			ServiceType serviceBO = response.getService();
			
			ServiceTO serviceTO = new ServiceTO();
			serviceTO.setId(serviceBO.getId());
			serviceTO.setName(serviceBO.getName());
			serviceTO.setVersion(serviceBO.getVersion());
			
			servicesTO.add(serviceTO);
		} catch (GetServiceFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return servicesTO;
	}

}
