package com.ebmwebsourcing.easiergov.services.ui.client;

import java.util.List;

import com.ebmwebsourcing.easiergov.services.ui.client.modelto.ServiceTO;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;



public class Application implements EntryPoint{

	@Override
	public void onModuleLoad() {
		final SearchRequestPanel searchRequestPanel = new SearchRequestPanel();
		final SearchResponsePanel searchResponsePanel = new SearchResponsePanel();
		searchRequestPanel.getSearchButton().addListener(new ButtonListenerAdapter() {
			@Override
			public void onClick(Button button, EventObject e) {

				SearchServicesAsync service = GWT.create(SearchServices.class);


				service.searchServices(searchRequestPanel.getSearchField().getText(), new AsyncCallback<List<ServiceTO>>() {

					@Override
					public void onSuccess(List<ServiceTO> servicesTO) {
						searchResponsePanel.setServices(servicesTO);
						searchResponsePanel.refresh();
						
					}
					
					
					@Override
					public void onFailure(Throwable e) {
						Window.alert(e.getMessage());
					}

				});

			}
		});
		searchRequestPanel.getSearchField();
		RootPanel.get().add(searchRequestPanel);

	}

}
