/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.sla;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.sla.AgreementResourceAnalyzerSlaImpl;
import com.petalslink.easiergov.sla.SlaManagerImpl;
import com.petalslink.resources_api._1_0.ResourcesManager;
import com.petalslink.sla_api._1.PublishTemplateFromURL;
import com.petalslink.sla_api._1.PublishTemplateFromURLResponse;
import com.petalslink.sla_api._1.ResourceIdentifier;
import com.petalslink.sla_api._1_0.FaultMessage;
import com.petalslink.sla_api._1_0.SlaManager;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementTemplateType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlaManagerTest {
    private SlaManager slaAPI = null;
    private ResourcesManagerImpl resourcesManager = null;

    @Before
    public void setup() throws GovException {
        this.resourcesManager = new ResourcesManagerImpl((Configuration)new ConfigurationImpl());
        this.slaAPI = new SlaManagerImpl((ResourcesManager)this.resourcesManager);
    }

    public List<ResourceIdentifier> publishTemplateFromURL(URL url) throws FaultMessage {
        PublishTemplateFromURL templateURL = new PublishTemplateFromURL();
        templateURL.setURL(url.toString());
        PublishTemplateFromURLResponse res = this.slaAPI.publishTemplateFromURL(templateURL);
        return res.getResourceIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishTemplateFromURL() throws FaultMessage, GovException {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new AgreementResourceAnalyzerSlaImpl());
            List<ResourceIdentifier> id = this.publishTemplateFromURL(Thread.currentThread().getContextClassLoader().getResource("agreementTemplate.xml"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertTrue((id.size() > 0 ? 1 : 0) != 0);
        }
        finally {
            this.resourcesManager.clear();
        }
    }

    @Test
    public void testFindTemplate() throws GovException {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new AgreementResourceAnalyzerSlaImpl());
            List<ResourceIdentifier> id = this.publishTemplateFromURL(Thread.currentThread().getContextClassLoader().getResource("agreementTemplate.xml"));
            QName serviceQname = new QName("http://www.example.org/firemen/", "firemen");
            List res = this.slaAPI.findTemplatesByService(serviceQname);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((int)1, (int)res.size());
            Assert.assertEquals((String)"AID1", (String)((EJaxbAgreementTemplateType)res.get(0)).getTemplateId());
        }
        catch (FaultMessage e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException e) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

