/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.smtp.server;

import com.ebmwebsourcing.easyesb.external.protocol.smtp.server.ServerProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class MailListener {
    private static Logger log = Logger.getLogger(MailListener.class.getName());

    public void closeFolderAndStore(Folder folder, Store store, boolean expunge) {
        block7: {
            block6: {
                try {
                    if (folder != null && folder.isOpen()) {
                        folder.close(expunge);
                    }
                }
                catch (Exception ex) {
                    if (folder == null) break block6;
                    log.log(Level.WARNING, "Error closing mail Folder :" + folder.toString(), ex);
                }
            }
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                if (store == null) break block7;
                log.log(Level.WARNING, "Error closing mail Store : " + store.toString(), ex);
            }
        }
    }

    public Session createSessionPropertiesFromDescriptor(ServerProperties consumeDescriptor) {
        Properties props = new Properties();
        props.put("mail.store.protocol", consumeDescriptor.getScheme());
        props.put("mail.host", consumeDescriptor.getHostname());
        if (consumeDescriptor.getUsername() != null) {
            props.put("mail.user", consumeDescriptor.getUsername());
        }
        return Session.getInstance((Properties)props);
    }

    public Folder getFolderAndOpen(Store store, ServerProperties consumeDescriptor) throws MessagingException {
        String msg = "";
        Folder folder = null;
        folder = store.getDefaultFolder();
        if (folder == null) {
            msg = "No default folder for this store : " + store.toString();
            throw new MessagingException(msg);
        }
        if ((folder = folder.getFolder(consumeDescriptor.getFolder())) == null) {
            msg = "Invalid folder : " + consumeDescriptor.getFolder();
            throw new MessagingException(msg);
        }
        folder.open(2);
        return folder;
    }

    public List<Message> getNewMails(Folder folder) throws MessagingException {
        Message[] lstMessage;
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Message message : lstMessage = folder.getMessages()) {
            if (message.isSet(Flags.Flag.DELETED)) continue;
            messages.add(message);
        }
        return messages;
    }

    public Store getStoreAndConnect(Session session, ServerProperties consumeDescriptor) throws MessagingException {
        Store store = null;
        store = session.getStore(consumeDescriptor.getScheme());
        store.connect(consumeDescriptor.getHostname(), Integer.parseInt(consumeDescriptor.getPort()), consumeDescriptor.getUsername(), consumeDescriptor.getPassword());
        return store;
    }
}

