/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.smtp.server;

import com.ebmwebsourcing.easyesb.external.protocol.smtp.server.MailListener;
import com.ebmwebsourcing.easyesb.external.protocol.smtp.server.ServerProperties;
import java.util.List;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class Pop3Server
extends Thread {
    private static Logger log = Logger.getLogger(Pop3Server.class.getName());
    protected MailListener mailSessionManager = new MailListener();
    protected ServerProperties consumeDescriptor;
    List<Message> messages = null;

    public Pop3Server(ServerProperties consumeDescriptor) {
        this.consumeDescriptor = consumeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Folder folder = null;
        Store store = null;
        try {
            Session session = this.mailSessionManager.createSessionPropertiesFromDescriptor(this.consumeDescriptor);
            store = this.mailSessionManager.getStoreAndConnect(session, this.consumeDescriptor);
            folder = this.mailSessionManager.getFolderAndOpen(store, this.consumeDescriptor);
            this.messages = this.mailSessionManager.getNewMails(folder);
            for (Message message : this.messages) {
                message.setFlag(Flags.Flag.DELETED, true);
            }
            this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
        }
        catch (MessagingException e) {
            try {
                log.warning(e.getMessage());
                this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
            }
            catch (Throwable throwable) {
                this.mailSessionManager.closeFolderAndStore(folder, store, this.consumeDescriptor.isDelete());
                throw throwable;
            }
        }
    }
}

