/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.soap.impl;

import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.ProvideDescriptor;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.StringHelper;
import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailSender {
    public void sendMail(MimeMessage mimeMessage, ProvideDescriptor sessionDescriptor, Session session) throws MessagingException {
        Transport transport = session.getTransport("smtp");
        if (!StringHelper.isNullOrEmpty(sessionDescriptor.getUsername()) && !StringHelper.isNullOrEmpty(sessionDescriptor.getPassword())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), sessionDescriptor.getPassword());
        } else if (!StringHelper.isNullOrEmpty(sessionDescriptor.getUsername())) {
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), sessionDescriptor.getUsername(), null);
        } else {
            System.out.println("TRANSPORT : " + sessionDescriptor.getHostname() + " " + sessionDescriptor.getPort());
            transport.connect(sessionDescriptor.getHostname(), Integer.parseInt(sessionDescriptor.getPort()), null, null);
        }
        mimeMessage.saveChanges();
        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        transport.close();
    }

    public MimeMessage createMimeMessage(Session session, ProvideDescriptor provideDescriptor, String content) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        String sendMode = provideDescriptor.getSendMode();
        this.setMimeMessageAttributes(mimeMessage, provideDescriptor.getToAddress(), provideDescriptor.getFromAddress(), provideDescriptor.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        this.setMimeMessageBody((Multipart)multipart, content, provideDescriptor.getContentType());
        try {
            mimeMessage.setContent((Multipart)multipart);
        }
        catch (MessagingException e) {
            String msg = "Error setting Mime message contentwith all information collected from NormalizedMessage";
            throw new MessagingException("Error setting Mime message contentwith all information collected from NormalizedMessage", (Exception)((Object)e));
        }
        return mimeMessage;
    }

    protected void setMimeMessageBody(Multipart multipart, String content, String contentType) throws MessagingException {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)content, contentType);
        multipart.addBodyPart((BodyPart)messageBodyPart);
    }

    protected void setMimeMessageAttributes(MimeMessage mimeMessage, String toAddress, String fromAddress, String subject) throws MessagingException {
        try {
            InternetAddress toInternetAddress = new InternetAddress(toAddress);
            mimeMessage.setRecipient(Message.RecipientType.TO, (Address)toInternetAddress);
            mimeMessage.setSentDate(new Date());
            if (fromAddress != null) {
                InternetAddress fromInternetAddress = new InternetAddress(fromAddress);
                mimeMessage.setFrom((Address)fromInternetAddress);
            }
            mimeMessage.setSubject(subject);
        }
        catch (MessagingException e) {
            String msg = "Error setting MimeMessage attributes";
            throw new MessagingException("Error setting MimeMessage attributes", (Exception)((Object)e));
        }
    }
}

