/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.MailSender;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.ProvideDescriptor;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SMTPSenderImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ProviderProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.petalslink.smtp._1.ObjectFactory;
import com.petalslink.smtp._1.TAddress;
import com.petalslink.smtp._1.TBinding;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.xml.parsers.DocumentBuilder;
import org.jdom.JDOMException;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SmtpProviderProxyBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements ProviderProxyBehaviour {
    private static Logger log = Logger.getLogger(SmtpProviderProxyBehaviourImpl.class.getName());
    private static DocumentBuilder db;
    private SMTPSenderImpl sender = new SMTPSenderImpl();

    public SmtpProviderProxyBehaviourImpl(ProviderProxyEndpoint ep) throws SOAPException {
        super((Endpoint)ep);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            this.sendExchange2ExternalProviderEndpoint(exchange);
            exchange.getMessageIn().getHeader().addProperty(MessageUtil.getInstance().createHeaderProperty(MessageUtil.EXCHANGE_ACCEPTED_BY_PROVIDER_PROPERTY, "true"));
        }
        catch (TransportException e) {
            throw new TransportException((Throwable)e);
        }
        catch (ESBException e) {
            throw new TransportException((Throwable)e);
        }
    }

    public Exchange sendExchange2ExternalProviderEndpoint(Exchange exchange) throws TransportException {
        try {
            Document request = SOAPSender.createSOAPMessageRequest((Document)exchange.getMessageIn().getBody().getPayload());
            Description desc = this.getEndpoint().getDescription();
            System.out.println("desc = " + desc);
            System.out.println("model class = " + ((Binding)desc.getBindings().iterator().next()).getModel().getClass());
            com.ebmwebsourcing.easywsdl11.api.element.Binding binding11 = (com.ebmwebsourcing.easywsdl11.api.element.Binding)((Binding)desc.getBindings().iterator().next()).getModel();
            Element elmt = (Element)binding11.getAnyXmlObjects()[0].getXmlObjectDOMNode();
            Element smtpServer = (Element)elmt.getElementsByTagNameNS("http://ww.petalslink.com/smtp/1.0", "smtp-server").item(0);
            Element portServer = (Element)elmt.getElementsByTagNameNS("http://ww.petalslink.com/smtp/1.0", "port").item(0);
            Document doc = db.newDocument();
            doc.appendChild(doc.adoptNode(elmt));
            TBinding mailBinding = (TBinding)SOAJAXBContext.getInstance().marshallAnyType(doc, TBinding.class);
            Service service = (Service)desc.getServices().iterator().next();
            Port port = (Port)service.getEndpoints()[0].getModel();
            Element address = (Element)port.getAnyXmlObjects()[0].getXmlObjectDOMNode();
            doc = db.newDocument();
            doc.appendChild(doc.adoptNode(address));
            TAddress mailAddress = (TAddress)SOAJAXBContext.getInstance().marshallAnyType(doc, TAddress.class);
            System.out.println("MAIL GET TO : " + mailAddress.getTo());
            MailSender sender = new MailSender();
            ProvideDescriptor provideDescriptor = new ProvideDescriptor();
            provideDescriptor.setScheme("smtp");
            provideDescriptor.setContentType("text/plain");
            provideDescriptor.setHostname(smtpServer.getTextContent());
            provideDescriptor.setPort(portServer.getTextContent());
            provideDescriptor.setFromAddress("nsalatge@there.com");
            provideDescriptor.setToAddress(mailAddress.getTo());
            Session session = this.createSessionPropertiesFromDescriptor(provideDescriptor);
            MimeMessage mimeMessage = sender.createMimeMessage(session, provideDescriptor, XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().getBody().getPayload()));
            sender.sendMail(mimeMessage, provideDescriptor, session);
        }
        catch (UnsupportedOperationException e) {
            throw new TransportException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new TransportException((Throwable)e);
        }
        catch (SOAException e) {
            throw new TransportException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new TransportException((Throwable)e);
        }
        return exchange;
    }

    public Session createSessionPropertiesFromDescriptor(ProvideDescriptor provideDescriptor) {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", provideDescriptor.getHostname());
        if (provideDescriptor.getUsername() != null) {
            props.put("mail.user", provideDescriptor.getUsername());
        }
        if (provideDescriptor.getFromAddress() != null) {
            props.put("mail.from", provideDescriptor.getFromAddress());
        }
        return Session.getInstance((Properties)props);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)db);
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            db = DocumentBuilders.takeDocumentBuilder();
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

