/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.process;

import com.petalslink.easiersbs.matching.message.api.matcher.MessageMatcher;
import com.petalslink.easiersbs.matching.process.api.ProcessMatchingFactory;
import com.petalslink.easiersbs.matching.process.api.matcher.MessageProcessMatcher;
import com.petalslink.easiersbs.matching.process.api.matcher.ServiceProcessMatcher;
import com.petalslink.easiersbs.matching.process.matcher.MessageProcessMatcherImpl;
import com.petalslink.easiersbs.matching.process.matcher.ServiceProcessMatcherImpl;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ProcessMatchingFactoryImpl implements ProcessMatchingFactory {

	public MessageProcessMatcher newMessageProcessMatcher(MessageMatcher matcher){
		return new MessageProcessMatcherImpl(matcher);
	}

	public ServiceProcessMatcher newServiceProcessMatcher(HybridMatcher matcher) {
		return new ServiceProcessMatcherImpl(matcher);
	}
	
	
	
}