/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.process.model;

import com.petalslink.easiersbs.matching.process.api.model.SyntacticRelation;
import com.petalslink.easiersbs.matching.process.api.model.SyntacticRelationType;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SyntacticRelationImpl implements SyntacticRelation {

	private static final long serialVersionUID = 1L;
	
	private String concept;
	private String value;
	private SyntacticRelationType type;

	protected SyntacticRelationImpl(){
		super();
	}
	
	public SyntacticRelationImpl(String concept, String value, SyntacticRelationType type){
		this.concept = concept;
		this.value = value;
		this.type = type;
	}

	public String getConcept() {
		return concept;
	}

	public void setConcept(String concept) {
		this.concept = concept;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public SyntacticRelationType getType() {
		return type;
	}

	public void setType(SyntacticRelationType type) {
		this.type = type;
	}

}
