/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.test;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.ReasonerFactoryImpl;
import com.petalslink.easiersbs.reasoner.impl.ontology.OntologyManagerImpl;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologyManagerTest {
    private ReasonerFactory factory = null;
    private OntologyManager manager = null;

    @Test
    @Before
    public void testCreateOntologyManager() throws ReasonerException {
        this.factory = ReasonerFactoryImpl.getInstance();
        Assert.assertNotNull((Object)this.factory);
        this.manager = this.factory.getOntologyManager();
        Assert.assertNotNull((Object)this.manager);
    }

    @Test
    public void testImportOntology() throws ReasonerException, URISyntaxException {
        this.manager.clearOntology();
        URI ontoURI = Thread.currentThread().getContextClassLoader().getResource("owl/SAPolicy.owl").toURI();
        this.manager.importOntology(ontoURI);
        OWLOntology onto = ((OntologyManagerImpl)this.manager).getMergedOntology();
        Assert.assertFalse((boolean)onto.isEmpty());
        Assert.assertNotNull((Object)onto);
        Assert.assertTrue((boolean)onto.containsEntityInSignature(IRI.create((String)"http://www.petalslink.com/ontologies/soa4all/policies.owl#Policy")));
        Assert.assertTrue((boolean)onto.containsEntityInSignature(IRI.create((String)"http://www.petalslink.com/ontologies/soa4all/policies.owl#SignedEndorsingSupportingTokens")));
        System.out.println(onto.getAxiomCount());
        Assert.assertEquals((int)163, (int)onto.getAxiomCount());
    }

    @Test
    public void testExportOntology() throws ReasonerException {
        String filepath = System.getProperty("user.dir") + "/target/tmp/save.owl";
        File filetest = new File(filepath);
        if (filetest.exists()) {
            filetest.delete();
        }
        this.manager.exportOntology(URI.create("file:" + filepath));
        Assert.assertTrue((boolean)filetest.exists());
    }

    @Test
    public void testClearOntology() throws ReasonerException {
        this.manager.clearOntology();
        OWLOntology onto = ((OntologyManagerImpl)this.manager).getMergedOntology();
        Assert.assertTrue((boolean)onto.isEmpty());
    }
}

