/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.reasoner.test;

import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.reasoner.api.ontology.OntologyManager;
import com.petalslink.easiersbs.reasoner.impl.ReasonerFactoryImpl;
import com.petalslink.easiersbs.reasoner.impl.engine.ReasonerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLOntology;

public class ReasonerTest {
    private ReasonerFactory factory = null;
    private OntologyManager manager = null;
    private Reasoner reasoner = null;
    Logger logger = Logger.getLogger(this.getClass().toString());
    static final String TEST_BASE_URI = "http://www.petalslink.com/easiersbs/test/reasoner.owl#";

    @Before
    public void setUp() throws ReasonerException, URISyntaxException {
        this.factory = ReasonerFactoryImpl.getInstance();
        this.manager = this.factory.getOntologyManager();
        this.manager.clearOntology();
    }

    @Test
    public void testCreateReasoner() throws ReasonerException, URISyntaxException {
        URI ontoURI = Thread.currentThread().getContextClassLoader().getResource("owl/SAPolicy.owl").toURI();
        this.manager.importOntology(ontoURI);
        this.reasoner = this.factory.newReasoner(this.manager);
        Assert.assertNotNull((Object)this.reasoner);
    }

    @Test
    public void testInference() throws ReasonerException, URISyntaxException {
        URI ontoURI = Thread.currentThread().getContextClassLoader().getResource("owl/W3CTestcase_description-logic_premise204.rdf").toURI();
        this.manager.importOntology(ontoURI);
        URI ontoURI2 = Thread.currentThread().getContextClassLoader().getResource("owl/W3CTestcase_description-logic_conclusion204.rdf").toURI();
        this.manager.importOntology(ontoURI2);
        this.reasoner = this.factory.newReasoner(this.manager);
        long start = System.currentTimeMillis();
        this.reasoner.infer();
        this.logger.fine("Inference time : " + (System.currentTimeMillis() - start) + " ms");
        OWLOntology onto = ((ReasonerImpl)this.reasoner).getReasonerOntology();
        Assert.assertEquals((int)784, (int)onto.getAxiomCount());
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
    }

    @Test
    public void testGetRelativeConcepts() throws ReasonerException, URISyntaxException {
        URI concept1 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Car");
        URI concept2 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Automobile");
        URI concept3 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Motorcycle");
        URI superConcept = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#PersonalTransport");
        URI indiv1 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Peugeot_206");
        URI ontoURI = Thread.currentThread().getContextClassLoader().getResource("owl/ReasonerTest.owl").toURI();
        this.manager.importOntology(ontoURI);
        this.reasoner = this.factory.newReasoner(this.manager);
        Set eqConcepts1 = this.reasoner.getEquivalentClasses(concept1);
        Assert.assertEquals((int)2, (int)eqConcepts1.size());
        Assert.assertTrue((boolean)eqConcepts1.contains(concept2));
        Assert.assertTrue((boolean)eqConcepts1.contains(concept1));
        Assert.assertFalse((boolean)eqConcepts1.contains(concept3));
        Set eqConcepts2 = this.reasoner.getEquivalentClasses(concept2);
        Assert.assertEquals((int)2, (int)eqConcepts2.size());
        Assert.assertTrue((boolean)eqConcepts2.contains(concept2));
        Assert.assertTrue((boolean)eqConcepts2.contains(concept1));
        Set superConcepts = this.reasoner.getSuperClasses(concept1);
        Assert.assertEquals((int)1, (int)superConcepts.size());
        Assert.assertTrue((boolean)superConcepts.contains(superConcept));
        Set subConcepts = this.reasoner.getSubClasses(superConcept);
        Assert.assertEquals((int)3, (int)subConcepts.size());
        Assert.assertTrue((boolean)subConcepts.contains(concept1));
        Assert.assertTrue((boolean)subConcepts.contains(concept2));
        Assert.assertTrue((boolean)subConcepts.contains(concept3));
        Set individuals = this.reasoner.getIndividuals(concept1);
        Assert.assertEquals((int)8, (int)individuals.size());
        Assert.assertTrue((boolean)individuals.contains(indiv1));
    }

    @Test
    public void testGetRelativeIndividuals() throws ReasonerException, URISyntaxException {
        URI indiv1 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Buick_Excelle");
        URI indiv2 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Peugeot_206");
        URI indiv3 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Holden_Viva");
        URI concept1 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Automobile");
        URI concept2 = new URI("http://www.petalslink.com/easiersbs/test/reasoner.owl#Car");
        URI ontoURI = Thread.currentThread().getContextClassLoader().getResource("owl/ReasonerTest.owl").toURI();
        this.manager.importOntology(ontoURI);
        this.reasoner = this.factory.newReasoner(this.manager);
        Set similarIndividuals = this.reasoner.getSimilarIndividuals(indiv1);
        Assert.assertEquals((int)8, (int)similarIndividuals.size());
        Assert.assertTrue((boolean)similarIndividuals.contains(indiv1));
        Assert.assertTrue((boolean)similarIndividuals.contains(indiv2));
        Assert.assertTrue((boolean)similarIndividuals.contains(indiv3));
        Set types = this.reasoner.getTypes(indiv1);
        Assert.assertEquals((int)2, (int)types.size());
        Assert.assertTrue((boolean)types.contains(concept1));
        Assert.assertTrue((boolean)types.contains(concept2));
        Assert.assertTrue((boolean)this.reasoner.isConcept(concept1));
        Assert.assertFalse((boolean)this.reasoner.isConcept(indiv1));
        Assert.assertTrue((boolean)this.reasoner.isInstance(indiv1));
        Assert.assertFalse((boolean)this.reasoner.isInstance(concept1));
    }
}

