/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.IWithModelReferenceBean;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public abstract class WithModelReferenceBean implements IWithModelReferenceBean {

	private static final long serialVersionUID = -7010955195641502235L;
	
	private List<String> modelReferences = new ArrayList<String>();

	public void addModelReference(String concept) {
		modelReferences.add(concept);
	}

	public List<String> getModelReferences() {
		return modelReferences;
	}

	public void removeModelReference(String concept) {
		modelReferences.remove(concept);
	}

}
