/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.flow;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.flow.ISemanticElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.flow.ISemanticElementsBean;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SemanticElementsBean implements ISemanticElementsBean {

	private static final long serialVersionUID = -6755184429427383208L;

	private List<ISemanticElementBean> elements = new ArrayList<ISemanticElementBean>();
	
	public SemanticElementsBean(){
		super();
	}
	
	public void addSemanticElement(ISemanticElementBean element) {
		elements.add(element);
	}

	public List<ISemanticElementBean> getSemanticElements() {
		return this.elements;
	}

	public void removeSemanticElement(ISemanticElementBean element) {
		elements.remove(element);
	}

}
