/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.service.extension.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticDetails;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticElement;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticElements;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.activity.FunctionalDescriptionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.activity.SemanticDetailsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.activity.IFunctionalDescriptionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.flow.ISemanticElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.flow.SemanticElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.flow.SemanticElementsBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBinder;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBindingManager;
import com.ebmwebsourcing.petalsbpm.service.extension.SabpmnExtensionBinder;
import java.net.URI;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class SabpmnExtensionBinderTest {
    SabpmnExtensionBinder binder = new SabpmnExtensionBinder();
    XmlContext context = new XmlContextFactory().newContext();
    ExtensionBindingManager manager;

    @Before
    @Test
    public void testSabpmnExtensionBinder() {
        if (this.manager == null) {
            this.manager = new ExtensionBindingManager();
        }
        List binders = this.manager.getBinders();
        Assert.assertNotNull((Object)binders);
        Assert.assertEquals((int)1, (int)binders.size());
        Assert.assertEquals(SabpmnExtensionBinder.class, ((ExtensionBinder)binders.get(0)).getClass());
    }

    @Test
    public void testSemanticDetails() throws XPathExpressionException, BPMNException {
        SemanticDetailsBean semanticDetails = new SemanticDetailsBean();
        FunctionalDescriptionBean functionalDesc = new FunctionalDescriptionBean("func");
        functionalDesc.addModelReference("http://funcConcept1");
        functionalDesc.addModelReference("http://funcConcept2");
        semanticDetails.setFunctionalDescription((IFunctionalDescriptionBean)functionalDesc);
        DefinitionsBean def = MockDefinitionsDB.getSingleExample();
        ITaskBean task = (ITaskBean)DefinitionsHelper.getInstance().getElementById(def, MockDefinitionsDB.UPPER_LANE_EL_2_ID);
        task.getObjectExtensions().add(semanticDetails);
        Definitions xmlDesc = ClientToServer.adapt((DefinitionsBean)def);
        XmlObjectXPathEvaluator xpathEvaluator = xmlDesc.getXmlContext().createXPathEvaluator();
        XmlObjectNode obj = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)xmlDesc, "//*[@id='" + MockDefinitionsDB.UPPER_LANE_EL_2_ID + "']", XmlObjectNode.class);
        Task xmlTask = (Task)obj;
        Assert.assertNotNull((Object)xmlTask);
        Assert.assertTrue((boolean)xmlTask.hasExtensionElements());
        ExtensionElements ext = xmlTask.getExtensionElements();
        Assert.assertEquals((int)1, (int)ext.getAnyXmlObjects().length);
        SemanticDetails semDetails = (SemanticDetails)ext.getAnyXmlObjects()[0];
        Assert.assertNotNull((Object)semDetails);
        Assert.assertNotNull((Object)semDetails.getFunctionalDescription());
        Assert.assertEquals((String)"func", (String)semDetails.getFunctionalDescription().getName());
        Assert.assertEquals((int)2, (int)semDetails.getFunctionalDescription().getModelReference().length);
        DefinitionsBean defAfter = ServerToClient.adapt((Definitions)xmlDesc);
        ITaskBean taskAfter = (ITaskBean)DefinitionsHelper.getInstance().getElementById(defAfter, MockDefinitionsDB.UPPER_LANE_EL_2_ID);
        Assert.assertNotNull((Object)taskAfter);
        Assert.assertNotNull((Object)taskAfter.getObjectExtensions());
        Assert.assertEquals((int)1, (int)taskAfter.getObjectExtensions().size());
        SemanticDetailsBean semanticDetailsAfter = (SemanticDetailsBean)taskAfter.getObjectExtensions().get(0);
        Assert.assertNotNull((Object)semanticDetailsAfter);
        Assert.assertEquals((String)"func", (String)semanticDetailsAfter.getFunctionalDescription().getName());
        Assert.assertEquals((int)2, (int)semanticDetailsAfter.getFunctionalDescription().getModelReferences().size());
    }

    @Test
    public void testSemanticElements() throws XPathExpressionException, BPMNException {
        SemanticElementsBean semanticElements = new SemanticElementsBean();
        SemanticElementBean semanticElement1 = new SemanticElementBean("Element1");
        semanticElement1.addModelReference("http://elem1");
        semanticElements.addSemanticElement((ISemanticElementBean)semanticElement1);
        SemanticElementBean semanticElement2 = new SemanticElementBean("Element2");
        semanticElement2.addModelReference("http://elem2Concept1");
        semanticElement2.addModelReference("http://elem2Concept2");
        semanticElements.addSemanticElement((ISemanticElementBean)semanticElement2);
        DefinitionsBean def = MockDefinitionsDB.getSingleExample();
        ISequenceFlowBean flow = (ISequenceFlowBean)DefinitionsHelper.getInstance().getElementById(def, MockDefinitionsDB.UPPER_LANE_EL_12_ID);
        flow.getObjectExtensions().add(semanticElements);
        Definitions xmlDesc = ClientToServer.adapt((DefinitionsBean)def);
        XmlObjectXPathEvaluator xpathEvaluator = xmlDesc.getXmlContext().createXPathEvaluator();
        XmlObjectNode obj = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)xmlDesc, "//*[@id='" + MockDefinitionsDB.UPPER_LANE_EL_12_ID + "']", XmlObjectNode.class);
        SequenceFlow xmlFlow = (SequenceFlow)obj;
        Assert.assertNotNull((Object)xmlFlow);
        Assert.assertTrue((boolean)xmlFlow.hasExtensionElements());
        ExtensionElements ext = xmlFlow.getExtensionElements();
        Assert.assertEquals((int)1, (int)ext.getAnyXmlObjects().length);
        SemanticElements semElements = (SemanticElements)ext.getAnyXmlObjects()[0];
        Assert.assertNotNull((Object)semElements);
        Assert.assertNotNull((Object)semElements.getSemanticElements());
        Assert.assertEquals((int)2, (int)semElements.getSemanticElements().length);
        for (SemanticElement elem : semElements.getSemanticElements()) {
            if (elem.getName().equals("Element1")) {
                Assert.assertEquals((int)1, (int)elem.getModelReference().length);
                Assert.assertEquals((Object)URI.create("http://elem1"), (Object)elem.getModelReference()[0]);
                continue;
            }
            if (elem.getName().equals("Element2")) {
                Assert.assertEquals((int)2, (int)elem.getModelReference().length);
                continue;
            }
            Assert.fail((String)"Unknown element in SemanticElements");
        }
        DefinitionsBean defAfter = ServerToClient.adapt((Definitions)xmlDesc);
        ISequenceFlowBean flowAfter = (ISequenceFlowBean)DefinitionsHelper.getInstance().getElementById(defAfter, MockDefinitionsDB.UPPER_LANE_EL_12_ID);
        Assert.assertNotNull((Object)flowAfter);
        Assert.assertNotNull((Object)flowAfter.getObjectExtensions());
        Assert.assertEquals((int)1, (int)flowAfter.getObjectExtensions().size());
        SemanticElementsBean semanticElementsAfter = (SemanticElementsBean)flowAfter.getObjectExtensions().get(0);
        Assert.assertNotNull((Object)semanticElementsAfter);
        Assert.assertEquals((int)2, (int)semanticElementsAfter.getSemanticElements().size());
        for (ISemanticElementBean elem : semanticElementsAfter.getSemanticElements()) {
            if (elem.getName().equals("Element1")) {
                Assert.assertEquals((int)1, (int)elem.getModelReferences().size());
                Assert.assertEquals((String)"http://elem1", (String)((String)elem.getModelReferences().get(0)));
                continue;
            }
            if (elem.getName().equals("Element2")) {
                Assert.assertEquals((int)2, (int)elem.getModelReferences().size());
                continue;
            }
            Assert.fail((String)"Unknow element in SemanticElementsBean");
        }
    }
}

