/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.ebmwebsourcing.petalsbpm.service.extension;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.FunctionalDescription;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticDetails;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticElement;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticElements;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.activity.FunctionalDescriptionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.activity.SemanticDetailsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.activity.IFunctionalDescriptionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.api.flow.ISemanticElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.flow.SemanticElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.sabpmn.to.flow.SemanticElementsBean;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBinder;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SabpmnExtensionBinder extends ExtensionBinder {
	
	private XmlContext context;
	
	@Override
	protected XmlObject clientToServer(ObjectExtension ext)
			throws IllegalArgumentException {
		
		if(ext instanceof SemanticDetailsBean){
			SemanticDetails res = getXmlContext().getXmlObjectFactory().create(SemanticDetails.class);
			
			//Functional description
			IFunctionalDescriptionBean extFunc = ((SemanticDetailsBean) ext).getFunctionalDescription();
			if(extFunc != null){
				FunctionalDescription func = getXmlContext().getXmlObjectFactory().create(FunctionalDescription.class);
				func.setName(extFunc.getName());
				for(String concept : extFunc.getModelReferences()){
					URI conceptUri = URI.create(concept);
					if(conceptUri != null){
						func.addModelReference(conceptUri);
					}
				}
				res.setFunctionalDescription(func);
			}
			return res;
			
		} else if(ext instanceof SemanticElementsBean){
			SemanticElements res = getXmlContext().getXmlObjectFactory().create(SemanticElements.class);
			
			for(ISemanticElementBean extElem : ((SemanticElementsBean) ext).getSemanticElements()){
				SemanticElement elem = getXmlContext().getXmlObjectFactory().create(SemanticElement.class);
				elem.setName(extElem.getName());
				for(String concept : extElem.getModelReferences()){
					URI conceptUri = URI.create(concept);
					if(conceptUri != null){
						elem.addModelReference(conceptUri);
					}
				}
				res.addSemanticElement(elem);
			}
			return res;
			
		}
		
		return null;
	}

	@Override
	protected List<Class<? extends ObjectExtension>> getSupportedBeans() {
		List<Class<? extends ObjectExtension>> result = new ArrayList<Class<? extends ObjectExtension>>();
		result.add(SemanticDetailsBean.class);
		result.add(SemanticElementsBean.class);
		return result;
	}

	@Override
	protected ObjectExtension serverToClient(XmlObject ext)
			throws IllegalArgumentException {
		if(ext instanceof SemanticDetails){
			SemanticDetailsBean res = new SemanticDetailsBean();
			
			//Functional description
			FunctionalDescription extFunc = ((SemanticDetails) ext).getFunctionalDescription();
			if(extFunc != null){
				FunctionalDescriptionBean func = new FunctionalDescriptionBean(extFunc.getName());
				for(URI concept : extFunc.getModelReference()){
					func.addModelReference(concept.toString());
				}
				res.setFunctionalDescription(func);
			}
			
			//TODO : Internal behavior & co
			
			return res;
			
		} else if (ext instanceof SemanticElements){
			
			SemanticElementsBean res = new SemanticElementsBean();
			
			for(SemanticElement extElem : ((SemanticElements) ext).getSemanticElements()){
				SemanticElementBean elem = new SemanticElementBean(extElem.getName());
				for(URI concept : extElem.getModelReference()){
					elem.addModelReference(concept.toString());
				}
				res.addSemanticElement(elem);
			}
			
			return res;
			
		}
		return null;
	}

	@Override
	protected List<Class<? extends XmlObject>> getSupportedXmlObjects() {
		List<Class<? extends XmlObject>> result = new ArrayList<Class<? extends XmlObject>>();
		result.add(SemanticDetails.class);
		result.add(SemanticElements.class);
		return result;
	}

	
	private XmlContext getXmlContext(){
		if(context==null){
			context = new XmlContextFactory().newContext();
		}
		return context;
	}

}
